/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

public class CrosshairInfo {
    protected double anchorX;
    protected double anchorY;
    protected double crosshairX;
    protected double crosshairY;
    protected double distance;

    public void setCrosshairDistance(double distance) {
        this.distance = distance;
    }

    public void updateCrosshairPoint(double candidateX, double candidateY) {
        double d = (candidateX - this.anchorX) * (candidateX - this.anchorX) + (candidateY - this.anchorY) * (candidateY - this.anchorY);
        if (d < this.distance) {
            this.crosshairX = candidateX;
            this.crosshairY = candidateY;
            this.distance = d;
        }
    }

    public void updateCrosshairX(double candidateX) {
        double d = Math.abs(candidateX - this.anchorX);
        if (d < this.distance) {
            this.crosshairX = candidateX;
            this.distance = d;
        }
    }

    public void updateCrosshairY(double candidateY) {
        double d = Math.abs(candidateY - this.anchorY);
        if (d < this.distance) {
            this.crosshairY = candidateY;
            this.distance = d;
        }
    }

    public void setAnchorX(double x) {
        this.anchorX = x;
    }

    public void setAnchorY(double y) {
        this.anchorY = y;
    }

    public double getCrosshairX() {
        return this.crosshairX;
    }

    public double getCrosshairY() {
        return this.crosshairY;
    }
}

