/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.Axis;
import com.jrefinery.chart.AxisNotCompatibleException;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.HorizontalAxis;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.VerticalAxis;
import com.jrefinery.chart.XYPlot;
import com.jrefinery.data.Range;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CombinedXYPlot
extends XYPlot {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private int type;
    protected List subplots;
    protected int seriesCount = 0;
    protected int totalWeight = 0;
    protected double gap = 5.0;

    public CombinedXYPlot(ValueAxis axis, int type) {
        super(null, type == 1 ? axis : null, type == 0 ? axis : null);
        if (type != 0 && type != 1) {
            throw new IllegalArgumentException("Invalid type (" + type + ")");
        }
        this.type = type;
        this.subplots = new ArrayList();
    }

    public void setGap(double gap) {
        this.gap = gap;
    }

    public double getGap() {
        return this.gap;
    }

    public void add(XYPlot subplot, int weight) throws AxisNotCompatibleException, IllegalArgumentException {
        if (!this.isValidSubHorizontalAxis((Axis)((Object)subplot.getHorizontalAxis()))) {
            throw new AxisNotCompatibleException("MultiXYPlot.add(...): invalid horizontal axis.");
        }
        if (!this.isValidSubVerticalAxis((Axis)((Object)subplot.getVerticalAxis()))) {
            throw new AxisNotCompatibleException("MultiXYPlot.add(...): invalid vertical axis.");
        }
        if (weight <= 0) {
            throw new IllegalArgumentException("MultiXYPlot.add(...): weight must be positive.");
        }
        subplot.setParent(this);
        subplot.setWeight(weight);
        subplot.setInsets(new Insets(0, 0, 0, 0));
        subplot.setFirstSeriesIndex(this.seriesCount);
        this.seriesCount += subplot.getSeriesCount();
        if (this.type == 1) {
            subplot.setDomainAxis(null);
        }
        if (this.type == 0) {
            subplot.setRangeAxis(null);
        }
        this.subplots.add(subplot);
        this.totalWeight += weight;
        if (this.type == 0) {
            this.getRangeAxis().configure();
        }
        if (this.type == 1) {
            this.getDomainAxis().configure();
        }
    }

    public boolean isValidSubHorizontalAxis(Axis axis) {
        boolean result = true;
        if (this.type == 1) {
            result = axis == null;
        }
        return result;
    }

    public boolean isValidSubVerticalAxis(Axis axis) {
        boolean result = true;
        if (this.type == 0) {
            result = axis == null;
        }
        return result;
    }

    public void draw(Graphics2D g2, Rectangle2D plotArea, ChartRenderingInfo info) {
        if (info != null) {
            info.setPlotArea(plotArea);
        }
        if (this.insets != null) {
            plotArea.setRect(plotArea.getX() + (double)this.insets.left, plotArea.getY() + (double)this.insets.top, plotArea.getWidth() - (double)this.insets.left - (double)this.insets.right, plotArea.getHeight() - (double)this.insets.top - (double)this.insets.bottom);
        }
        double sharedAxisDimension = 0.0;
        if (this.type == 1) {
            HorizontalAxis hAxis = this.getHorizontalAxis();
            if (hAxis != null) {
                sharedAxisDimension = hAxis.reserveHeight(g2, this, plotArea);
            }
        } else {
            VerticalAxis vAxis = this.getVerticalAxis();
            if (vAxis != null) {
                sharedAxisDimension = vAxis.reserveWidth(g2, this, plotArea);
            }
        }
        Rectangle2D.Double dataArea = this.type == 0 ? new Rectangle2D.Double(plotArea.getX() + sharedAxisDimension, plotArea.getY(), plotArea.getWidth() - sharedAxisDimension, plotArea.getHeight()) : new Rectangle2D.Double(plotArea.getX(), plotArea.getY(), plotArea.getWidth(), plotArea.getHeight() - sharedAxisDimension);
        int n = this.subplots.size();
        Rectangle2D[] subPlotArea = new Rectangle2D[n];
        double x = ((RectangularShape)dataArea).getX();
        double y = ((RectangularShape)dataArea).getY();
        double usableWidth = ((RectangularShape)dataArea).getWidth();
        if (this.type == 0) {
            usableWidth -= this.gap * (double)(n - 1);
        }
        double usableHeight = ((RectangularShape)dataArea).getHeight();
        if (this.type == 1) {
            usableHeight -= this.gap * (double)(n - 1);
        }
        double maxAxisWidth = Double.MIN_VALUE;
        double maxAxisHeight = Double.MIN_VALUE;
        int i = 0;
        while (i < n) {
            XYPlot plot = (XYPlot)this.subplots.get(i);
            double subPlotAreaHeight = usableHeight;
            if (this.type == 1) {
                subPlotAreaHeight *= (double)plot.getWeight() / (double)this.totalWeight;
            }
            double subPlotAreaWidth = usableWidth;
            if (this.type == 0) {
                subPlotAreaWidth *= (double)plot.getWeight() / (double)this.totalWeight;
            }
            subPlotArea[i] = new Rectangle2D.Double(x, y, subPlotAreaWidth, subPlotAreaHeight);
            if (this.type == 1) {
                maxAxisWidth = Math.max(maxAxisWidth, plot.getVerticalAxis().reserveWidth(g2, plot, subPlotArea[i]));
            } else if (this.type == 0) {
                maxAxisHeight = Math.max(maxAxisHeight, plot.getHorizontalAxis().reserveHeight(g2, plot, subPlotArea[i]));
            }
            if (this.type == 1) {
                y += subPlotAreaHeight + this.gap;
            } else if (this.type == 0) {
                x += subPlotAreaWidth + this.gap;
            }
            ++i;
        }
        if (this.type == 1) {
            this.setVerticalAxisWidth(maxAxisWidth);
            ((Rectangle2D)dataArea).setRect(((RectangularShape)dataArea).getX() + maxAxisWidth, ((RectangularShape)dataArea).getY(), ((RectangularShape)dataArea).getWidth() - maxAxisWidth, ((RectangularShape)dataArea).getHeight());
            this.domainAxis.draw(g2, plotArea, dataArea);
        } else if (this.type == 0) {
            this.setHorizontalAxisHeight(maxAxisHeight);
            ((Rectangle2D)dataArea).setRect(((RectangularShape)dataArea).getX(), ((RectangularShape)dataArea).getY(), ((RectangularShape)dataArea).getWidth(), ((RectangularShape)dataArea).getHeight() - maxAxisHeight);
            this.rangeAxis.draw(g2, plotArea, dataArea);
        }
        if (info != null) {
            info.setDataArea(dataArea);
        }
        int i2 = 0;
        while (i2 < n) {
            XYPlot plot = (XYPlot)this.subplots.get(i2);
            plot.draw(g2, subPlotArea[i2], info);
            ++i2;
        }
    }

    protected void setHorizontalAxisHeight(double height) {
        Iterator iterator = this.subplots.iterator();
        while (iterator.hasNext()) {
            XYPlot plot = (XYPlot)iterator.next();
            ValueAxis axis = plot.getDomainAxis();
            axis.setFixedDimension(height);
        }
    }

    protected void setVerticalAxisWidth(double width) {
        Iterator iterator = this.subplots.iterator();
        while (iterator.hasNext()) {
            XYPlot plot = (XYPlot)iterator.next();
            ValueAxis axis = plot.getRangeAxis();
            axis.setFixedDimension(width);
        }
    }

    public void zoom(double percent) {
    }

    public List getLegendItemLabels() {
        ArrayList result = new ArrayList();
        if (this.subplots != null) {
            Iterator iterator = this.subplots.iterator();
            while (iterator.hasNext()) {
                XYPlot plot = (XYPlot)iterator.next();
                List more = plot.getLegendItemLabels();
                result.addAll(more);
            }
        }
        return result;
    }

    public String getPlotType() {
        switch (this.type) {
            case 0: {
                return "Horizontal MultiXYPlot";
            }
            case 1: {
                return "Vertical MultiXYPlot";
            }
        }
        return "Unknown";
    }

    public Range getHorizontalDataRange() {
        Range result = null;
        if (this.type == 1 && this.subplots != null) {
            Iterator iterator = this.subplots.iterator();
            while (iterator.hasNext()) {
                XYPlot subplot = (XYPlot)iterator.next();
                result = Range.combine(result, subplot.getHorizontalDataRange());
            }
        }
        return result;
    }

    public Range getVerticalDataRange() {
        Range result = null;
        if (this.type == 0 && this.subplots != null) {
            Iterator iterator = this.subplots.iterator();
            while (iterator.hasNext()) {
                XYPlot subplot = (XYPlot)iterator.next();
                result = Range.combine(result, subplot.getVerticalDataRange());
            }
        }
        return result;
    }

    static {
        HORIZONTAL = 0;
        VERTICAL = 1;
    }
}

