/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.entity.CategoryItemEntity;
import com.jrefinery.chart.entity.ChartEntity;
import com.jrefinery.chart.entity.EntityCollection;
import com.jrefinery.chart.entity.PieSectionEntity;
import com.jrefinery.chart.entity.XYItemEntity;
import com.keypoint.PngEncoder;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Iterator;

public class ChartUtilities {
    public static void writeChartAsPNG(OutputStream out, JFreeChart chart, int width, int height) throws IOException {
        ChartUtilities.writeChartAsPNG(out, chart, width, height, null);
    }

    public static void writeChartAsPNG(OutputStream out, JFreeChart chart, int width, int height, ChartRenderingInfo info) throws IOException {
        BufferedImage chartImage = chart.createBufferedImage(width, height, info);
        PngEncoder encoder = new PngEncoder((Image)chartImage, false, 0, 9);
        byte[] pngData = encoder.pngEncode();
        out.write(pngData);
    }

    public static void saveChartAsPNG(File file, JFreeChart chart, int width, int height) throws IOException {
        ChartUtilities.saveChartAsPNG(file, chart, width, height, null);
    }

    public static void saveChartAsPNG(File file, JFreeChart chart, int width, int height, ChartRenderingInfo info) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        ChartUtilities.writeChartAsPNG(out, chart, width, height, info);
        ((OutputStream)out).close();
    }

    public static void writeChartAsJPEG(OutputStream out, JFreeChart chart, int width, int height) throws IOException {
        BufferedImage image = chart.createBufferedImage(width, height);
        JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
        JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(image);
        param.setQuality(1.0f, true);
        encoder.encode(image, param);
    }

    public static void saveChartAsJPEG(File file, JFreeChart chart, int width, int height) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        ChartUtilities.writeChartAsJPEG(out, chart, width, height);
        ((OutputStream)out).close();
    }

    public static void writeImageMap(PrintWriter writer, String name, String hrefPrefix, ChartRenderingInfo info) throws IOException {
        writer.println("<MAP NAME=\"" + name + "\">");
        EntityCollection entities = info.getEntityCollection();
        Iterator iterator = entities.iterator();
        while (iterator.hasNext()) {
            ChartEntity entity = (ChartEntity)iterator.next();
            if (entity instanceof PieSectionEntity) {
                PieSectionEntity pse = (PieSectionEntity)entity;
                writer.println(pse.getImageMapAreaTag(hrefPrefix));
                continue;
            }
            if (entity instanceof CategoryItemEntity) {
                CategoryItemEntity cie = (CategoryItemEntity)entity;
                writer.println(cie.getImageMapAreaTag(hrefPrefix));
                continue;
            }
            if (!(entity instanceof XYItemEntity)) continue;
            XYItemEntity xyie = (XYItemEntity)entity;
            writer.println(xyie.getImageMapAreaTag(hrefPrefix));
        }
        writer.println("</MAP>");
    }
}

