/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.ChartMouseEvent;
import com.jrefinery.chart.ChartMouseListener;
import com.jrefinery.chart.ChartPanelConstants;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.ChartUtilities;
import com.jrefinery.chart.HorizontalValuePlot;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.VerticalValuePlot;
import com.jrefinery.chart.entity.ChartEntity;
import com.jrefinery.chart.entity.EntityCollection;
import com.jrefinery.chart.event.ChartChangeEvent;
import com.jrefinery.chart.event.ChartChangeListener;
import com.jrefinery.chart.ui.ChartPropertyEditPanel;
import com.jrefinery.ui.ExtensionFileFilter;
import com.jrefinery.ui.RefineryUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.ToolTipManager;

public class ChartPanel
extends JPanel
implements ChartPanelConstants,
ActionListener,
MouseListener,
MouseMotionListener,
Printable,
ChartChangeListener {
    protected JFreeChart chart;
    protected List chartMouseListeners;
    protected boolean useBuffer;
    protected boolean refreshBuffer;
    protected Image chartBuffer;
    protected int chartBufferHeight;
    protected int chartBufferWidth;
    protected int minimumDrawWidth;
    protected int minimumDrawHeight;
    protected int maximumDrawWidth;
    protected int maximumDrawHeight;
    protected JPopupMenu popup;
    protected ChartRenderingInfo info;
    protected double scaleX;
    protected double scaleY;
    protected Rectangle2D zoomRectangle = null;
    protected Point2D zoomPoint = null;
    protected boolean fillZoomRectangle = false;
    protected boolean horizontalZoom = false;
    protected boolean verticalZoom = false;
    protected boolean horizontalAxisTrace = false;
    protected boolean verticalAxisTrace = false;
    protected JMenuItem zoomInBothAxesMenuItem;
    protected JMenuItem zoomInHorizontalMenuItem;
    protected JMenuItem zoomInVerticalMenuItem;
    protected JMenuItem zoomOutBothMenuItem;
    protected JMenuItem zoomOutHorizontalMenuItem;
    protected JMenuItem zoomOutVerticalMenuItem;
    protected JMenuItem autoRangeBothMenuItem;
    protected JMenuItem autoRangeHorizontalMenuItem;
    protected JMenuItem autoRangeVerticalMenuItem;
    private Rectangle2D available = new Rectangle2D.Double();
    private Rectangle2D chartArea = new Rectangle2D.Double();
    private Line2D verticalTraceLine;
    private Line2D horizontalTraceLine;

    public ChartPanel(JFreeChart chart) {
        this(chart, 680, 420, 300, 200, 800, 600, true, true, true, true, true, true);
    }

    public ChartPanel(JFreeChart chart, boolean properties, boolean save, boolean print, boolean zoom, boolean tooltips) {
        this(chart, 680, 420, 300, 200, 800, 600, true, properties, save, print, zoom, tooltips);
    }

    public ChartPanel(JFreeChart chart, int width, int height, int minimumDrawWidth, int minimumDrawHeight, int maximumDrawWidth, int maximumDrawHeight, boolean useBuffer, boolean properties, boolean save, boolean print, boolean zoom, boolean tooltips) {
        this.chart = chart;
        this.chartMouseListeners = new ArrayList();
        this.info = new ChartRenderingInfo();
        this.setPreferredSize(new Dimension(width, height));
        this.useBuffer = useBuffer;
        this.refreshBuffer = false;
        this.chart.addChangeListener(this);
        this.minimumDrawWidth = minimumDrawWidth;
        this.minimumDrawHeight = minimumDrawHeight;
        this.maximumDrawWidth = maximumDrawWidth;
        this.maximumDrawHeight = maximumDrawHeight;
        this.popup = null;
        if (properties || save || print || zoom) {
            this.popup = this.createPopupMenu(properties, save, print, zoom);
        }
        this.enableEvents(16L);
        this.enableEvents(32L);
        this.setGenerateToolTips(tooltips);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setOpaque(true);
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public void setChart(JFreeChart chart) {
        if (this.chart != null) {
            this.chart.removeChangeListener(this);
        }
        this.chart = chart;
        this.chart.addChangeListener(this);
        if (this.useBuffer) {
            this.refreshBuffer = true;
        }
        Plot plot = chart.getPlot();
        this.horizontalZoom = this.horizontalZoom && plot instanceof HorizontalValuePlot;
        this.verticalZoom = this.verticalZoom && plot instanceof VerticalValuePlot;
        this.repaint();
    }

    public int getMinimumDrawWidth() {
        return this.minimumDrawWidth;
    }

    public void setMinimumDrawWidth(int width) {
        this.minimumDrawWidth = width;
    }

    public int getMaximumDrawWidth() {
        return this.maximumDrawWidth;
    }

    public void setMaximumDrawWidth(int width) {
        this.maximumDrawWidth = width;
    }

    public void setMinimumDrawHeight(int height) {
        this.minimumDrawHeight = height;
    }

    public int getMinimumDrawHeight() {
        return this.minimumDrawHeight;
    }

    public int getMaximumDrawHeight() {
        return this.maximumDrawHeight;
    }

    public void setMaximumDrawHeight(int height) {
        this.maximumDrawHeight = height;
    }

    public void setMouseZoomable(boolean flag) {
        this.setMouseZoomable(flag, true);
    }

    public void setMouseZoomable(boolean flag, boolean fillRectangle) {
        this.setHorizontalZoom(flag);
        this.setVerticalZoom(flag);
        this.setFillZoomRectangle(fillRectangle);
    }

    public void setHorizontalZoom(boolean flag) {
        this.horizontalZoom = flag && this.chart.getPlot() instanceof HorizontalValuePlot;
    }

    public void setFillZoomRectangle(boolean flag) {
        this.fillZoomRectangle = flag;
    }

    public void setVerticalZoom(boolean flag) {
        this.verticalZoom = flag && this.chart.getPlot() instanceof VerticalValuePlot;
    }

    public void setHorizontalAxisTrace(boolean flag) {
        this.horizontalAxisTrace = flag;
    }

    public void setVerticalAxisTrace(boolean flag) {
        this.verticalAxisTrace = flag;
    }

    public void setGenerateToolTips(boolean flag) {
        this.info.setGenerateToolTips(flag);
        if (flag) {
            ToolTipManager.sharedInstance().registerComponent(this);
        } else {
            ToolTipManager.sharedInstance().unregisterComponent(this);
        }
    }

    public String getToolTipText(MouseEvent e) {
        EntityCollection entities;
        String result = null;
        if (this.info.isGenerateToolTips() && (entities = this.info.getEntityCollection()) != null) {
            Insets insets = this.getInsets();
            ChartEntity entity = entities.getEntity((int)((double)(e.getX() - insets.left) / this.scaleX), (int)((double)(e.getY() - insets.top) / this.scaleY));
            if (entity != null) {
                result = entity.getToolTipText();
            }
        }
        return result;
    }

    public void setRefreshBuffer(boolean flag) {
        this.refreshBuffer = flag;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        Dimension size = this.getSize();
        Insets insets = this.getInsets();
        this.available.setRect(insets.left, insets.top, size.getWidth() - (double)insets.left - (double)insets.right, size.getHeight() - (double)insets.top - (double)insets.bottom);
        boolean scale = false;
        double drawWidth = this.available.getWidth();
        double drawHeight = this.available.getHeight();
        this.scaleX = 1.0;
        this.scaleY = 1.0;
        if (drawWidth < (double)this.minimumDrawWidth) {
            this.scaleX = drawWidth / (double)this.minimumDrawWidth;
            drawWidth = this.minimumDrawWidth;
            scale = true;
        } else if (drawWidth > (double)this.maximumDrawWidth) {
            this.scaleX = drawWidth / (double)this.maximumDrawWidth;
            drawWidth = this.maximumDrawWidth;
            scale = true;
        }
        if (drawHeight < (double)this.minimumDrawHeight) {
            this.scaleY = drawHeight / (double)this.minimumDrawHeight;
            drawHeight = this.minimumDrawHeight;
            scale = true;
        } else if (drawHeight > (double)this.maximumDrawHeight) {
            this.scaleY = drawHeight / (double)this.maximumDrawHeight;
            drawHeight = this.maximumDrawHeight;
            scale = true;
        }
        this.chartArea.setRect(0.0, 0.0, drawWidth, drawHeight);
        AffineTransform scalingTransform = AffineTransform.getScaleInstance(this.scaleX, this.scaleY);
        if (this.useBuffer) {
            if (this.chartBuffer == null || (double)this.chartBufferWidth != this.available.getWidth() || (double)this.chartBufferHeight != this.available.getHeight()) {
                this.chartBufferWidth = (int)this.available.getWidth();
                this.chartBufferHeight = (int)this.available.getHeight();
                this.chartBuffer = this.createImage(this.chartBufferWidth, this.chartBufferHeight);
                this.refreshBuffer = true;
            }
            if (this.refreshBuffer) {
                Rectangle2D.Double bufferArea = new Rectangle2D.Double(0.0, 0.0, this.chartBufferWidth, this.chartBufferHeight);
                Graphics2D bufferG2 = (Graphics2D)this.chartBuffer.getGraphics();
                if (scale) {
                    AffineTransform saved = bufferG2.getTransform();
                    bufferG2.transform(scalingTransform);
                    this.chart.draw(bufferG2, this.chartArea, this.info);
                    bufferG2.setTransform(saved);
                } else {
                    this.chart.draw(bufferG2, bufferArea, this.info);
                }
                this.refreshBuffer = false;
            }
            g.drawImage(this.chartBuffer, insets.left, insets.right, this);
        } else {
            AffineTransform saved = g2.getTransform();
            g2.translate(insets.left, insets.right);
            if (scale) {
                g2.transform(scalingTransform);
            }
            this.chart.draw(g2, this.chartArea, this.info);
            g2.setTransform(saved);
        }
        this.verticalTraceLine = null;
        this.horizontalTraceLine = null;
    }

    public void chartChanged(ChartChangeEvent event) {
        this.refreshBuffer = true;
        this.repaint();
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals("PROPERTIES")) {
            this.attemptEditChartProperties();
        } else if (command.equals("SAVE")) {
            try {
                this.doSaveAs();
            }
            catch (IOException e) {
                System.err.println("ChartPanel.doSaveAs: i/o exception = " + e.getMessage());
            }
        } else if (command.equals("PRINT")) {
            this.createChartPrintJob();
        } else if (command.equals("ZOOM_IN_BOTH")) {
            this.zoomInBoth(this.zoomPoint.getX(), this.zoomPoint.getY());
        } else if (command.equals("ZOOM_IN_HORIZONTAL")) {
            this.zoomInHorizontal(this.zoomPoint.getX());
        } else if (command.equals("ZOOM_IN_VERTICAL")) {
            this.zoomInVertical(this.zoomPoint.getY());
        } else if (command.equals("ZOOM_OUT_BOTH")) {
            this.zoomOutBoth(this.zoomPoint.getX(), this.zoomPoint.getY());
        } else if (command.equals("ZOOM_HORIZONTAL_BOTH")) {
            this.zoomOutHorizontal(this.zoomPoint.getX());
        } else if (command.equals("ZOOM_VERTICAL_BOTH")) {
            this.zoomOutVertical(this.zoomPoint.getY());
        } else if (command.equals("AUTO_RANGE_BOTH")) {
            this.autoRangeBoth();
        } else if (command.equals("AUTO_RANGE_HORIZONTAL")) {
            this.autoRangeHorizontal();
        } else if (command.equals("AUTO_RANGE_VERTICAL")) {
            this.autoRangeVertical();
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (this.zoomRectangle == null) {
            this.zoomPoint = RefineryUtilities.getPointInRectangle(e.getX(), e.getY(), this.getScaledDataArea());
            if (e.isPopupTrigger() && this.popup != null) {
                this.displayPopupMenu(e.getX(), e.getY());
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.zoomRectangle != null) {
            if (Math.abs((double)e.getX() - this.zoomPoint.getX()) >= 20.0) {
                if ((double)e.getX() < this.zoomPoint.getX() && (double)e.getY() < this.zoomPoint.getY()) {
                    this.autoRangeBoth();
                } else {
                    double w = Math.min(this.zoomRectangle.getWidth(), this.getScaledDataArea().getMaxX() - this.zoomPoint.getX());
                    double h = Math.min(this.zoomRectangle.getHeight(), this.getScaledDataArea().getMaxY() - this.zoomPoint.getY());
                    Rectangle2D.Double zoomArea = new Rectangle2D.Double(this.zoomPoint.getX(), this.zoomPoint.getY(), w, h);
                    this.zoom(zoomArea);
                }
                this.zoomPoint = null;
                this.zoomRectangle = null;
            } else {
                Graphics2D g2 = (Graphics2D)this.getGraphics();
                g2.setXORMode(Color.gray);
                if (this.fillZoomRectangle) {
                    g2.fill(this.zoomRectangle);
                } else {
                    g2.draw(this.zoomRectangle);
                }
                g2.dispose();
                this.zoomRectangle = null;
            }
        } else if (e.isPopupTrigger() && this.popup != null) {
            this.displayPopupMenu(e.getX(), e.getY());
        }
    }

    public void mouseClicked(MouseEvent event) {
        Insets insets = this.getInsets();
        int x = (int)((double)(event.getX() - insets.left) / this.scaleX);
        int y = (int)((double)(event.getY() - insets.top) / this.scaleY);
        this.chart.handleClick(x, y, this.info);
        if (this.chartMouseListeners.isEmpty()) {
            return;
        }
        ChartEntity entity = this.info.getEntityCollection().getEntity(x, y);
        ChartMouseEvent chartEvent = new ChartMouseEvent(event, entity);
        Iterator iterator = this.chartMouseListeners.iterator();
        while (iterator.hasNext()) {
            ChartMouseListener listener = (ChartMouseListener)iterator.next();
            listener.chartMouseClicked(chartEvent);
        }
    }

    public void mouseMoved(MouseEvent e) {
        if (this.horizontalAxisTrace) {
            this.drawHorizontalAxisTrace(e.getX());
        }
        if (this.verticalAxisTrace) {
            this.drawVerticalAxisTrace(e.getY());
        }
        if (this.chartMouseListeners.isEmpty()) {
            return;
        }
        Insets insets = this.getInsets();
        int x = (int)((double)(e.getX() - insets.left) / this.scaleX);
        int y = (int)((double)(e.getY() - insets.top) / this.scaleY);
        ChartEntity entity = this.info.getEntityCollection().getEntity(x, y);
        ChartMouseEvent event = new ChartMouseEvent(e, entity);
        Iterator iterator = this.chartMouseListeners.iterator();
        while (iterator.hasNext()) {
            ChartMouseListener listener = (ChartMouseListener)iterator.next();
            listener.chartMouseMoved(event);
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.popup != null && this.popup.isShowing()) {
            return;
        }
        Graphics2D g2 = (Graphics2D)this.getGraphics();
        g2.setXORMode(Color.gray);
        if (this.zoomRectangle != null) {
            if (this.fillZoomRectangle) {
                g2.fill(this.zoomRectangle);
            } else {
                g2.draw(this.zoomRectangle);
            }
        }
        Rectangle2D scaledDataArea = this.getScaledDataArea();
        if (this.horizontalZoom && this.verticalZoom) {
            double xmax = Math.min((double)e.getX(), scaledDataArea.getMaxX());
            double ymax = Math.min((double)e.getY(), scaledDataArea.getMaxY());
            this.zoomRectangle = new Rectangle2D.Double(this.zoomPoint.getX(), this.zoomPoint.getY(), xmax - this.zoomPoint.getX(), ymax - this.zoomPoint.getY());
        }
        if (this.zoomRectangle != null) {
            if (this.fillZoomRectangle) {
                g2.fill(this.zoomRectangle);
            } else {
                g2.draw(this.zoomRectangle);
            }
        }
        g2.dispose();
    }

    public void zoomInBoth(double x, double y) {
        this.zoomInHorizontal(x);
        this.zoomInVertical(y);
    }

    public void zoomInHorizontal(double x) {
        if (this.chart.getPlot() instanceof HorizontalValuePlot) {
            HorizontalValuePlot hvp = (HorizontalValuePlot)((Object)this.chart.getPlot());
            ValueAxis axis = hvp.getHorizontalValueAxis();
            double value = axis.translateJava2DtoValue((float)x, this.info.getDataArea());
            axis.resizeRange(0.5, value);
        }
    }

    public void zoomInVertical(double y) {
        if (this.chart.getPlot() instanceof VerticalValuePlot) {
            VerticalValuePlot vvp = (VerticalValuePlot)((Object)this.chart.getPlot());
            ValueAxis axis = vvp.getVerticalValueAxis();
            double value = axis.translateJava2DtoValue((float)y, this.info.getDataArea());
            axis.resizeRange(0.5, value);
        }
    }

    public void zoomOutBoth(double x, double y) {
        this.zoomOutHorizontal(x);
        this.zoomOutVertical(y);
    }

    public void zoomOutHorizontal(double x) {
        if (this.chart.getPlot() instanceof HorizontalValuePlot) {
            HorizontalValuePlot hvp = (HorizontalValuePlot)((Object)this.chart.getPlot());
            ValueAxis axis = hvp.getHorizontalValueAxis();
            double value = axis.translateJava2DtoValue((float)x, this.info.getDataArea());
            axis.resizeRange(2.0, value);
        }
    }

    public void zoomOutVertical(double y) {
        if (this.chart.getPlot() instanceof VerticalValuePlot) {
            VerticalValuePlot vvp = (VerticalValuePlot)((Object)this.chart.getPlot());
            ValueAxis axis = vvp.getVerticalValueAxis();
            double value = axis.translateJava2DtoValue((float)y, this.info.getDataArea());
            axis.resizeRange(2.0, value);
        }
    }

    public void zoom(Rectangle2D selection) {
        if (selection.getHeight() > 0.0 && selection.getWidth() > 0.0) {
            double upper;
            double lower;
            ValueAxis axis;
            Rectangle2D scaledDataArea = this.getScaledDataArea();
            if (this.chart.getPlot() instanceof HorizontalValuePlot) {
                HorizontalValuePlot hvp = (HorizontalValuePlot)((Object)this.chart.getPlot());
                axis = hvp.getHorizontalValueAxis();
                lower = axis.translateJava2DtoValue((float)selection.getX(), scaledDataArea);
                upper = axis.translateJava2DtoValue((float)selection.getMaxX(), scaledDataArea);
                axis.setRange(lower, upper);
            }
            if (this.chart.getPlot() instanceof VerticalValuePlot) {
                VerticalValuePlot vvp = (VerticalValuePlot)((Object)this.chart.getPlot());
                axis = vvp.getVerticalValueAxis();
                lower = axis.translateJava2DtoValue((float)selection.getMaxY(), scaledDataArea);
                upper = axis.translateJava2DtoValue((float)selection.getY(), scaledDataArea);
                axis.setRange(lower, upper);
            }
        }
    }

    public void autoRangeBoth() {
        this.autoRangeHorizontal();
        this.autoRangeVertical();
    }

    public void autoRangeHorizontal() {
        if (this.chart.getPlot() instanceof HorizontalValuePlot) {
            HorizontalValuePlot hvp = (HorizontalValuePlot)((Object)this.chart.getPlot());
            ValueAxis axis = hvp.getHorizontalValueAxis();
            axis.setAutoRange(true);
        }
    }

    public void autoRangeVertical() {
        Plot p = this.chart.getPlot();
        if (p instanceof VerticalValuePlot) {
            VerticalValuePlot plot = (VerticalValuePlot)((Object)p);
            ValueAxis axis = plot.getVerticalValueAxis();
            axis.setAutoRange(true);
        }
    }

    public Rectangle2D getScaledDataArea() {
        Rectangle2D dataArea = this.info.getDataArea();
        Insets insets = this.getInsets();
        double x = dataArea.getX() * this.scaleX + (double)insets.left;
        double y = dataArea.getY() * this.scaleY + (double)insets.top;
        double w = dataArea.getWidth() * this.scaleX;
        double h = dataArea.getHeight() * this.scaleY;
        return new Rectangle2D.Double(x, y, w, h);
    }

    private void drawHorizontalAxisTrace(int x) {
        Graphics2D g2 = (Graphics2D)this.getGraphics();
        Rectangle2D dataArea = this.getScaledDataArea();
        g2.setXORMode(Color.orange);
        if ((int)dataArea.getMinX() < x && x < (int)dataArea.getMaxX()) {
            if (this.verticalTraceLine != null) {
                g2.draw(this.verticalTraceLine);
                this.verticalTraceLine.setLine(x, (int)dataArea.getMinY(), x, (int)dataArea.getMaxY());
            } else {
                this.verticalTraceLine = new Line2D.Float(x, (int)dataArea.getMinY(), x, (int)dataArea.getMaxY());
            }
            g2.draw(this.verticalTraceLine);
        }
    }

    private void drawVerticalAxisTrace(int y) {
        Graphics2D g2 = (Graphics2D)this.getGraphics();
        Rectangle2D dataArea = this.getScaledDataArea();
        g2.setXORMode(Color.orange);
        if ((int)dataArea.getMinY() < y && y < (int)dataArea.getMaxY()) {
            if (this.horizontalTraceLine != null) {
                g2.draw(this.horizontalTraceLine);
                this.horizontalTraceLine.setLine((int)dataArea.getMinX(), y, (int)dataArea.getMaxX(), y);
            } else {
                this.horizontalTraceLine = new Line2D.Float((int)dataArea.getMinX(), y, (int)dataArea.getMaxX(), y);
            }
            g2.draw(this.horizontalTraceLine);
        }
    }

    private void attemptEditChartProperties() {
        ChartPropertyEditPanel panel = new ChartPropertyEditPanel(this.chart);
        int result = JOptionPane.showConfirmDialog(this, panel, "Chart Properties", 2, -1);
        if (result == 0) {
            panel.updateChartProperties(this.chart);
        }
    }

    public void doSaveAs() throws IOException {
        JFileChooser fileChooser = new JFileChooser();
        ExtensionFileFilter filter = new ExtensionFileFilter("PNG Image Files", ".png");
        fileChooser.addChoosableFileFilter(filter);
        int option = fileChooser.showSaveDialog(this);
        if (option == 0) {
            ChartUtilities.saveChartAsPNG(fileChooser.getSelectedFile(), this.chart, this.getWidth(), this.getHeight());
        }
    }

    public void createChartPrintJob() {
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPrintable(this);
        if (job.printDialog()) {
            try {
                job.print();
            }
            catch (PrinterException e) {
                JOptionPane.showMessageDialog(this, e);
            }
        }
    }

    public int print(Graphics g, PageFormat pf, int pageIndex) {
        if (pageIndex != 0) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)g;
        double x = pf.getImageableX();
        double y = pf.getImageableY();
        double w = pf.getImageableWidth();
        double h = pf.getImageableHeight();
        this.chart.draw(g2, new Rectangle2D.Double(x, y, w, h), null);
        return 0;
    }

    public void addChartMouseListener(ChartMouseListener listener) {
        this.chartMouseListeners.add(listener);
    }

    public void removeChartMouseListener(ChartMouseListener listener) {
        this.chartMouseListeners.remove(listener);
    }

    protected JPopupMenu createPopupMenu(boolean properties, boolean save, boolean print, boolean zoom) {
        JPopupMenu result = new JPopupMenu("Chart:");
        boolean separator = false;
        if (properties) {
            JMenuItem propertiesItem = new JMenuItem("Properties...");
            propertiesItem.setActionCommand("PROPERTIES");
            propertiesItem.addActionListener(this);
            result.add(propertiesItem);
            separator = true;
        }
        if (save) {
            if (separator) {
                result.addSeparator();
                separator = false;
            }
            JMenuItem saveItem = new JMenuItem("Save as...");
            saveItem.setActionCommand("SAVE");
            saveItem.addActionListener(this);
            result.add(saveItem);
            separator = true;
        }
        if (print) {
            if (separator) {
                result.addSeparator();
                separator = false;
            }
            JMenuItem printItem = new JMenuItem("Print...");
            printItem.setActionCommand("PRINT");
            printItem.addActionListener(this);
            result.add(printItem);
            separator = true;
        }
        if (zoom) {
            if (separator) {
                result.addSeparator();
                separator = false;
            }
            JMenu zoomInMenu = new JMenu("Zoom In");
            JMenuItem zoomInBothAxesMenuItem = new JMenuItem("Both Axes");
            zoomInBothAxesMenuItem.setActionCommand("ZOOM_IN_BOTH");
            zoomInBothAxesMenuItem.addActionListener(this);
            zoomInMenu.add(zoomInBothAxesMenuItem);
            zoomInMenu.addSeparator();
            this.zoomInHorizontalMenuItem = new JMenuItem("Horizontal Axis");
            this.zoomInHorizontalMenuItem.setActionCommand("ZOOM_IN_HORIZONTAL");
            this.zoomInHorizontalMenuItem.addActionListener(this);
            zoomInMenu.add(this.zoomInHorizontalMenuItem);
            this.zoomInVerticalMenuItem = new JMenuItem("Vertical Axis");
            this.zoomInVerticalMenuItem.setActionCommand("ZOOM_IN_VERTICAL");
            this.zoomInVerticalMenuItem.addActionListener(this);
            zoomInMenu.add(this.zoomInVerticalMenuItem);
            result.add(zoomInMenu);
            JMenu zoomOutMenu = new JMenu("Zoom Out");
            JMenuItem zoomOutBothMenuItem = new JMenuItem("Both Axes");
            zoomOutBothMenuItem.setActionCommand("ZOOM_OUT_BOTH");
            zoomOutBothMenuItem.addActionListener(this);
            zoomOutMenu.add(zoomOutBothMenuItem);
            zoomOutMenu.addSeparator();
            this.zoomOutHorizontalMenuItem = new JMenuItem("Horizontal Axis");
            this.zoomOutHorizontalMenuItem.setActionCommand("ZOOM_HORIZONTAL_BOTH");
            this.zoomOutHorizontalMenuItem.addActionListener(this);
            zoomOutMenu.add(this.zoomOutHorizontalMenuItem);
            this.zoomOutVerticalMenuItem = new JMenuItem("Vertical Axis");
            this.zoomOutVerticalMenuItem.setActionCommand("ZOOM_VERTICAL_BOTH");
            this.zoomOutVerticalMenuItem.addActionListener(this);
            zoomOutMenu.add(this.zoomOutVerticalMenuItem);
            result.add(zoomOutMenu);
            JMenu autoRangeMenu = new JMenu("Auto Range");
            this.autoRangeBothMenuItem = new JMenuItem("Both Axes");
            this.autoRangeBothMenuItem.setActionCommand("AUTO_RANGE_BOTH");
            this.autoRangeBothMenuItem.addActionListener(this);
            autoRangeMenu.add(this.autoRangeBothMenuItem);
            autoRangeMenu.addSeparator();
            this.autoRangeHorizontalMenuItem = new JMenuItem("Horizontal Axis");
            this.autoRangeHorizontalMenuItem.setActionCommand("AUTO_RANGE_HORIZONTAL");
            this.autoRangeHorizontalMenuItem.addActionListener(this);
            autoRangeMenu.add(this.autoRangeHorizontalMenuItem);
            this.autoRangeVerticalMenuItem = new JMenuItem("Vertical Axis");
            this.autoRangeVerticalMenuItem.setActionCommand("AUTO_RANGE_VERTICAL");
            this.autoRangeVerticalMenuItem.addActionListener(this);
            autoRangeMenu.add(this.autoRangeVerticalMenuItem);
            result.addSeparator();
            result.add(autoRangeMenu);
        }
        return result;
    }

    private void displayPopupMenu(int x, int y) {
        if (this.popup != null) {
            Plot plot = this.chart.getPlot();
            if (plot instanceof HorizontalValuePlot) {
                // empty if block
            }
            this.popup.show(this, x, y);
        }
    }
}

