/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AreaCategoryItemRenderer;
import com.jrefinery.chart.AreaXYItemRenderer;
import com.jrefinery.chart.CandlestickRenderer;
import com.jrefinery.chart.HighLowRenderer;
import com.jrefinery.chart.HorizontalBarRenderer;
import com.jrefinery.chart.HorizontalBarRenderer3D;
import com.jrefinery.chart.HorizontalCategoryAxis;
import com.jrefinery.chart.HorizontalCategoryPlot;
import com.jrefinery.chart.HorizontalDateAxis;
import com.jrefinery.chart.HorizontalIntervalBarRenderer;
import com.jrefinery.chart.HorizontalNumberAxis;
import com.jrefinery.chart.HorizontalNumberAxis3D;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.JFreeChartConstants;
import com.jrefinery.chart.LineAndShapeRenderer;
import com.jrefinery.chart.Pie3DPlot;
import com.jrefinery.chart.PiePlot;
import com.jrefinery.chart.SignalRenderer;
import com.jrefinery.chart.StackedHorizontalBarRenderer;
import com.jrefinery.chart.StackedVerticalBarRenderer;
import com.jrefinery.chart.StackedVerticalBarRenderer3D;
import com.jrefinery.chart.StandardXYItemRenderer;
import com.jrefinery.chart.VerticalBarRenderer;
import com.jrefinery.chart.VerticalBarRenderer3D;
import com.jrefinery.chart.VerticalCategoryAxis;
import com.jrefinery.chart.VerticalCategoryPlot;
import com.jrefinery.chart.VerticalNumberAxis;
import com.jrefinery.chart.VerticalNumberAxis3D;
import com.jrefinery.chart.VerticalXYBarRenderer;
import com.jrefinery.chart.WindItemRenderer;
import com.jrefinery.chart.XYPlot;
import com.jrefinery.chart.tooltips.HighLowToolTipGenerator;
import com.jrefinery.chart.tooltips.StandardXYToolTipGenerator;
import com.jrefinery.chart.tooltips.TimeSeriesToolTipGenerator;
import com.jrefinery.data.CategoryDataset;
import com.jrefinery.data.HighLowDataset;
import com.jrefinery.data.IntervalCategoryDataset;
import com.jrefinery.data.IntervalXYDataset;
import com.jrefinery.data.PieDataset;
import com.jrefinery.data.SignalsDataset;
import com.jrefinery.data.WindDataset;
import com.jrefinery.data.XYDataset;
import java.awt.Insets;

public class ChartFactory {
    public static JFreeChart createVerticalBarChart(String title, String categoryAxisLabel, String valueAxisLabel, CategoryDataset data, boolean legend) {
        HorizontalCategoryAxis categoryAxis = new HorizontalCategoryAxis(categoryAxisLabel);
        VerticalNumberAxis valueAxis = new VerticalNumberAxis(valueAxisLabel);
        VerticalBarRenderer renderer = new VerticalBarRenderer();
        VerticalCategoryPlot plot = new VerticalCategoryPlot(data, categoryAxis, valueAxis, renderer);
        JFreeChart chart = new JFreeChart(title, JFreeChartConstants.DEFAULT_TITLE_FONT, plot, legend);
        return chart;
    }

    public static JFreeChart createVerticalBarChart3D(String title, String categoryAxisLabel, String valueAxisLabel, CategoryDataset data, boolean legend) {
        HorizontalCategoryAxis categoryAxis = new HorizontalCategoryAxis(categoryAxisLabel);
        VerticalNumberAxis3D valueAxis = new VerticalNumberAxis3D(valueAxisLabel);
        VerticalBarRenderer3D renderer = new VerticalBarRenderer3D();
        VerticalCategoryPlot plot = new VerticalCategoryPlot(data, categoryAxis, valueAxis, renderer);
        JFreeChart chart = new JFreeChart(title, JFreeChartConstants.DEFAULT_TITLE_FONT, plot, legend);
        return chart;
    }

    public static JFreeChart createStackedVerticalBarChart(String title, String categoryAxisLabel, String valueAxisLabel, CategoryDataset data, boolean legend) {
        HorizontalCategoryAxis categoryAxis = new HorizontalCategoryAxis(categoryAxisLabel);
        VerticalNumberAxis valueAxis = new VerticalNumberAxis(valueAxisLabel);
        StackedVerticalBarRenderer renderer = new StackedVerticalBarRenderer();
        VerticalCategoryPlot plot = new VerticalCategoryPlot(data, categoryAxis, valueAxis, renderer);
        JFreeChart chart = new JFreeChart(title, JFreeChartConstants.DEFAULT_TITLE_FONT, plot, legend);
        return chart;
    }

    public static JFreeChart createStackedVerticalBarChart3D(String title, String categoryAxisLabel, String valueAxisLabel, CategoryDataset data, boolean legend) {
        HorizontalCategoryAxis categoryAxis = new HorizontalCategoryAxis(categoryAxisLabel);
        VerticalNumberAxis3D valueAxis = new VerticalNumberAxis3D(valueAxisLabel);
        StackedVerticalBarRenderer3D renderer = new StackedVerticalBarRenderer3D();
        VerticalCategoryPlot plot = new VerticalCategoryPlot(data, categoryAxis, valueAxis, renderer);
        plot.setInsets(new Insets(20, 2, 2, 2));
        JFreeChart chart = new JFreeChart(title, JFreeChartConstants.DEFAULT_TITLE_FONT, plot, legend);
        return chart;
    }

    public static JFreeChart createHorizontalBarChart(String title, String domainAxisLabel, String rangeAxisLabel, CategoryDataset data, boolean legend) {
        VerticalCategoryAxis domainAxis = new VerticalCategoryAxis(domainAxisLabel);
        HorizontalNumberAxis rangeAxis = new HorizontalNumberAxis(rangeAxisLabel);
        HorizontalBarRenderer renderer = new HorizontalBarRenderer();
        HorizontalCategoryPlot plot = new HorizontalCategoryPlot(data, domainAxis, rangeAxis, renderer);
        JFreeChart chart = new JFreeChart(title, JFreeChartConstants.DEFAULT_TITLE_FONT, plot, legend);
        return chart;
    }

    public static JFreeChart createHorizontalBarChart3D(String title, String categoryAxisLabel, String valueAxisLabel, CategoryDataset data, boolean legend) {
        VerticalCategoryAxis categoryAxis = new VerticalCategoryAxis(categoryAxisLabel);
        HorizontalNumberAxis3D valueAxis = new HorizontalNumberAxis3D(valueAxisLabel);
        HorizontalBarRenderer3D renderer = new HorizontalBarRenderer3D();
        HorizontalCategoryPlot plot = new HorizontalCategoryPlot(data, categoryAxis, valueAxis, renderer);
        plot.setForegroundAlpha(0.75f);
        JFreeChart chart = new JFreeChart(title, JFreeChartConstants.DEFAULT_TITLE_FONT, plot, legend);
        return chart;
    }

    public static JFreeChart createStackedHorizontalBarChart(String title, String domainAxisLabel, String rangeAxisLabel, CategoryDataset data, boolean legend) {
        VerticalCategoryAxis domainAxis = new VerticalCategoryAxis(domainAxisLabel);
        HorizontalNumberAxis rangeAxis = new HorizontalNumberAxis(rangeAxisLabel);
        StackedHorizontalBarRenderer renderer = new StackedHorizontalBarRenderer();
        HorizontalCategoryPlot plot = new HorizontalCategoryPlot(data, domainAxis, rangeAxis, renderer);
        JFreeChart chart = new JFreeChart(title, JFreeChartConstants.DEFAULT_TITLE_FONT, plot, legend);
        return chart;
    }

    public static JFreeChart createLineChart(String title, String categoryAxisLabel, String valueAxisLabel, CategoryDataset data, boolean legend) {
        HorizontalCategoryAxis categoryAxis = new HorizontalCategoryAxis(categoryAxisLabel);
        VerticalNumberAxis valueAxis = new VerticalNumberAxis(valueAxisLabel);
        LineAndShapeRenderer renderer = new LineAndShapeRenderer();
        VerticalCategoryPlot plot = new VerticalCategoryPlot(data, categoryAxis, valueAxis, renderer);
        JFreeChart chart = new JFreeChart(title, JFreeChartConstants.DEFAULT_TITLE_FONT, plot, legend);
        return chart;
    }

    public static JFreeChart createAreaChart(String title, String categoryAxisLabel, String valueAxisLabel, CategoryDataset data, boolean legend) {
        HorizontalCategoryAxis categoryAxis = new HorizontalCategoryAxis(categoryAxisLabel);
        VerticalNumberAxis valueAxis = new VerticalNumberAxis(valueAxisLabel);
        AreaCategoryItemRenderer renderer = new AreaCategoryItemRenderer();
        VerticalCategoryPlot plot = new VerticalCategoryPlot(data, categoryAxis, valueAxis, renderer);
        JFreeChart chart = new JFreeChart(title, JFreeChartConstants.DEFAULT_TITLE_FONT, plot, legend);
        return chart;
    }

    public static JFreeChart createGanttChart(String title, String categoryAxisLabel, String dateAxisLabel, IntervalCategoryDataset data, boolean legend) {
        VerticalCategoryAxis categoryAxis = new VerticalCategoryAxis(categoryAxisLabel);
        HorizontalDateAxis dateAxis = new HorizontalDateAxis(dateAxisLabel);
        HorizontalIntervalBarRenderer renderer = new HorizontalIntervalBarRenderer();
        HorizontalCategoryPlot plot = new HorizontalCategoryPlot(data, categoryAxis, dateAxis, renderer);
        JFreeChart chart = new JFreeChart(title, JFreeChartConstants.DEFAULT_TITLE_FONT, plot, legend);
        return chart;
    }

    public static JFreeChart createPieChart(String title, PieDataset data, boolean legend) {
        PiePlot plot = new PiePlot(data);
        plot.setInsets(new Insets(0, 5, 5, 5));
        JFreeChart chart = new JFreeChart(title, JFreeChartConstants.DEFAULT_TITLE_FONT, plot, legend);
        return chart;
    }

    public static JFreeChart createPie3DChart(String title, PieDataset data, boolean legend) {
        Pie3DPlot plot = new Pie3DPlot(data);
        plot.setInsets(new Insets(0, 5, 5, 5));
        JFreeChart chart = new JFreeChart(title, JFreeChartConstants.DEFAULT_TITLE_FONT, plot, legend);
        return chart;
    }

    public static JFreeChart createXYChart(String title, String xAxisLabel, String yAxisLabel, XYDataset data, boolean legend) {
        HorizontalNumberAxis xAxis = new HorizontalNumberAxis(xAxisLabel);
        xAxis.setAutoRangeIncludesZero(false);
        VerticalNumberAxis yAxis = new VerticalNumberAxis(yAxisLabel);
        XYPlot plot = new XYPlot(data, xAxis, yAxis);
        plot.setXYItemRenderer(new StandardXYItemRenderer(2, new StandardXYToolTipGenerator()));
        JFreeChart chart = new JFreeChart(title, JFreeChartConstants.DEFAULT_TITLE_FONT, plot, legend);
        return chart;
    }

    public static JFreeChart createAreaXYChart(String title, String xAxisLabel, String yAxisLabel, XYDataset data, boolean legend) {
        HorizontalNumberAxis xAxis = new HorizontalNumberAxis(xAxisLabel);
        xAxis.setAutoRangeIncludesZero(false);
        VerticalNumberAxis yAxis = new VerticalNumberAxis(yAxisLabel);
        XYPlot plot = new XYPlot(data, xAxis, yAxis);
        plot.setXYItemRenderer(new AreaXYItemRenderer());
        JFreeChart chart = new JFreeChart(title, JFreeChartConstants.DEFAULT_TITLE_FONT, plot, legend);
        return chart;
    }

    public static JFreeChart createScatterPlot(String title, String xAxisLabel, String yAxisLabel, XYDataset data, boolean legend) {
        HorizontalNumberAxis xAxis = new HorizontalNumberAxis(xAxisLabel);
        VerticalNumberAxis yAxis = new VerticalNumberAxis(yAxisLabel);
        XYPlot plot = new XYPlot(data, xAxis, yAxis);
        plot.setXYItemRenderer(new StandardXYItemRenderer(1, new StandardXYToolTipGenerator()));
        JFreeChart chart = new JFreeChart(title, JFreeChartConstants.DEFAULT_TITLE_FONT, plot, legend);
        return chart;
    }

    public static JFreeChart createWindPlot(String title, String xAxisLabel, String yAxisLabel, WindDataset data, boolean legend) {
        HorizontalDateAxis xAxis = new HorizontalDateAxis(xAxisLabel);
        VerticalNumberAxis yAxis = new VerticalNumberAxis(yAxisLabel);
        yAxis.setMaximumAxisValue(12.0);
        yAxis.setMinimumAxisValue(-12.0);
        XYPlot plot = new XYPlot(data, xAxis, yAxis);
        plot.setXYItemRenderer(new WindItemRenderer());
        JFreeChart chart = new JFreeChart(title, JFreeChartConstants.DEFAULT_TITLE_FONT, plot, legend);
        return chart;
    }

    public static JFreeChart createTimeSeriesChart(String title, String timeAxisLabel, String valueAxisLabel, XYDataset data, boolean legend) {
        HorizontalDateAxis timeAxis = new HorizontalDateAxis(timeAxisLabel);
        VerticalNumberAxis valueAxis = new VerticalNumberAxis(valueAxisLabel);
        valueAxis.setAutoRangeIncludesZero(false);
        XYPlot plot = new XYPlot(data, timeAxis, valueAxis);
        plot.setXYItemRenderer(new StandardXYItemRenderer(2, new TimeSeriesToolTipGenerator()));
        JFreeChart chart = new JFreeChart(title, JFreeChartConstants.DEFAULT_TITLE_FONT, plot, legend);
        return chart;
    }

    public static JFreeChart createVerticalXYBarChart(String title, String xAxisLabel, String yAxisLabel, IntervalXYDataset data, boolean legend) {
        HorizontalDateAxis dateAxis = new HorizontalDateAxis(xAxisLabel);
        VerticalNumberAxis valueAxis = new VerticalNumberAxis(yAxisLabel);
        XYPlot plot = new XYPlot(data, dateAxis, valueAxis);
        plot.setXYItemRenderer(new VerticalXYBarRenderer());
        JFreeChart chart = new JFreeChart(title, JFreeChartConstants.DEFAULT_TITLE_FONT, plot, legend);
        return chart;
    }

    public static JFreeChart createHighLowChart(String title, String timeAxisLabel, String valueAxisLabel, HighLowDataset data, boolean legend) {
        HorizontalDateAxis timeAxis = new HorizontalDateAxis(timeAxisLabel);
        VerticalNumberAxis valueAxis = new VerticalNumberAxis(valueAxisLabel);
        XYPlot plot = new XYPlot(data, timeAxis, valueAxis);
        plot.setXYItemRenderer(new HighLowRenderer(new HighLowToolTipGenerator()));
        JFreeChart chart = new JFreeChart(title, JFreeChartConstants.DEFAULT_TITLE_FONT, plot, legend);
        return chart;
    }

    public static JFreeChart createCandlestickChart(String title, String timeAxisLabel, String valueAxisLabel, HighLowDataset data, boolean legend) {
        HorizontalDateAxis timeAxis = new HorizontalDateAxis(timeAxisLabel);
        VerticalNumberAxis valueAxis = new VerticalNumberAxis(valueAxisLabel);
        XYPlot plot = new XYPlot(data, timeAxis, valueAxis);
        plot.setXYItemRenderer(new CandlestickRenderer());
        JFreeChart chart = new JFreeChart(title, JFreeChartConstants.DEFAULT_TITLE_FONT, plot, legend);
        return chart;
    }

    public static JFreeChart createSignalChart(String title, String timeAxisLabel, String valueAxisLabel, SignalsDataset data, boolean legend) {
        HorizontalDateAxis timeAxis = new HorizontalDateAxis(timeAxisLabel);
        VerticalNumberAxis valueAxis = new VerticalNumberAxis(valueAxisLabel);
        XYPlot plot = new XYPlot(data, timeAxis, valueAxis);
        plot.setXYItemRenderer(new SignalRenderer());
        JFreeChart chart = new JFreeChart(title, JFreeChartConstants.DEFAULT_TITLE_FONT, plot, legend);
        return chart;
    }
}

