/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AbstractXYItemRenderer;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.CrosshairInfo;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.XYItemRenderer;
import com.jrefinery.chart.XYPlot;
import com.jrefinery.chart.entity.EntityCollection;
import com.jrefinery.chart.entity.XYItemEntity;
import com.jrefinery.chart.tooltips.HighLowToolTipGenerator;
import com.jrefinery.chart.tooltips.XYToolTipGenerator;
import com.jrefinery.data.HighLowDataset;
import com.jrefinery.data.XYDataset;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class CandlestickRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer {
    protected double candleWidth;
    protected Paint upPaint;
    protected Paint downPaint;
    protected boolean drawVolume;

    public CandlestickRenderer() {
        this(-1.0);
    }

    public CandlestickRenderer(double candleWidth) {
        this(candleWidth, true, new HighLowToolTipGenerator());
    }

    public CandlestickRenderer(double candleWidth, boolean drawVolume, XYToolTipGenerator toolTipGenerator) {
        this.candleWidth = candleWidth;
        this.drawVolume = drawVolume;
        this.upPaint = Color.green;
        this.downPaint = Color.red;
        this.toolTipGenerator = toolTipGenerator;
    }

    public double getCandleWidth() {
        return this.candleWidth;
    }

    public void setCandleWidth(double width) {
        if (width != this.candleWidth) {
            Double old = new Double(this.candleWidth);
            this.candleWidth = width;
            this.firePropertyChanged("CandleStickRenderer.candleWidth", old, new Double(width));
        }
    }

    public Paint getUpPaint() {
        return this.upPaint;
    }

    public void setUpPaint(Paint paint) {
        Paint old = this.upPaint;
        this.upPaint = paint;
        this.firePropertyChanged("CandleStickRenderer.upPaint", old, paint);
    }

    public Paint getDownPaint() {
        return this.downPaint;
    }

    public void setDownPaint(Paint paint) {
        Paint old = this.upPaint;
        this.downPaint = paint;
        this.firePropertyChanged("CandleStickRenderer.downPaint", old, paint);
    }

    public boolean drawVolume() {
        return this.drawVolume;
    }

    public void setDrawVolume(boolean flag) {
        if (this.drawVolume != flag) {
            this.drawVolume = flag;
            this.firePropertyChanged("CandlestickRenderer.drawVolume", null, new Boolean(flag));
        }
    }

    public void drawItem(Graphics2D g2, Rectangle2D dataArea, ChartRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset data, int series, int item, CrosshairInfo crosshairInfo) {
        EntityCollection entities = null;
        if (info != null) {
            entities = info.getEntityCollection();
        }
        HighLowDataset highLowData = (HighLowDataset)data;
        Number x = highLowData.getXValue(series, item);
        Number yHigh = highLowData.getHighValue(series, item);
        Number yLow = highLowData.getLowValue(series, item);
        Number yOpen = highLowData.getOpenValue(series, item);
        Number yClose = highLowData.getCloseValue(series, item);
        double xx = domainAxis.translateValueToJava2D(x.doubleValue(), dataArea);
        double yyHigh = rangeAxis.translateValueToJava2D(yHigh.doubleValue(), dataArea);
        double yyLow = rangeAxis.translateValueToJava2D(yLow.doubleValue(), dataArea);
        double yyOpen = rangeAxis.translateValueToJava2D(yOpen.doubleValue(), dataArea);
        double yyClose = rangeAxis.translateValueToJava2D(yClose.doubleValue(), dataArea);
        double exactCandleWidth = this.candleWidth;
        double thisCandleWidth = this.candleWidth;
        if (this.candleWidth <= 0.0) {
            int itemCount = highLowData.getItemCount(series);
            exactCandleWidth = (dataArea.getMaxX() - dataArea.getMinX()) / (double)itemCount * 4.5 / 7.0;
            if (exactCandleWidth < 1.0) {
                exactCandleWidth = 1.0;
            }
            if ((thisCandleWidth = exactCandleWidth) < 3.0) {
                thisCandleWidth = 3.0;
            }
        }
        Paint p = plot.getSeriesPaint(series);
        Stroke s = plot.getSeriesStroke(series);
        g2.setStroke(s);
        if (this.drawVolume) {
            int volume = highLowData.getVolumeValue(series, item).intValue();
            int maxVolume = 1;
            int maxCount = highLowData.getItemCount(series);
            int i = 0;
            while (i < maxCount) {
                int thisVolume = highLowData.getVolumeValue(series, i).intValue();
                if (thisVolume > maxVolume) {
                    maxVolume = thisVolume;
                }
                ++i;
            }
            double drawVolume = (double)volume / (double)maxVolume;
            double minY = dataArea.getMinY();
            double maxY = dataArea.getMaxY();
            double yyVolume = drawVolume * (maxY - minY);
            g2.setPaint(Color.gray);
            Composite originalComposite = g2.getComposite();
            g2.setComposite(AlphaComposite.getInstance(3, 0.3f));
            Rectangle2D.Double box = new Rectangle2D.Double(xx - exactCandleWidth / 2.0, maxY - yyVolume, exactCandleWidth, yyVolume);
            g2.fill(box);
            g2.setComposite(originalComposite);
        }
        g2.setPaint(p);
        if (yyHigh < yyOpen && yyHigh < yyClose) {
            g2.draw(new Line2D.Double(xx, yyHigh, xx, Math.min(yyOpen, yyClose)));
        }
        if (yyLow > yyOpen && yyLow > yyClose) {
            g2.draw(new Line2D.Double(xx, yyLow, xx, Math.max(yyOpen, yyClose)));
        }
        Rectangle2D.Double body = null;
        if (yyOpen > yyClose) {
            body = new Rectangle2D.Double(xx - thisCandleWidth / 2.0, yyClose, thisCandleWidth, yyOpen - yyClose);
            if (this.upPaint != null) {
                g2.setPaint(this.upPaint);
                g2.fill(body);
            }
            g2.setPaint(p);
            g2.draw(body);
        } else {
            body = new Rectangle2D.Double(xx - thisCandleWidth / 2.0, yyOpen, thisCandleWidth, yyClose - yyOpen);
            if (this.downPaint != null) {
                g2.setPaint(this.downPaint);
            }
            g2.fill(body);
            g2.setPaint(p);
            g2.draw(body);
        }
        if (entities != null) {
            String tip = "";
            if (this.toolTipGenerator != null) {
                tip = this.toolTipGenerator.generateToolTip(data, series, item);
            }
            XYItemEntity entity = new XYItemEntity(body, tip, series, item);
            entities.addEntity(entity);
        }
    }
}

