/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AbstractCategoryItemRenderer;
import com.jrefinery.chart.CategoryPlot;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.tooltips.CategoryToolTipGenerator;
import com.jrefinery.data.CategoryDataset;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

public abstract class BarRenderer
extends AbstractCategoryItemRenderer {
    protected static final double BAR_OUTLINE_WIDTH_THRESHOLD = 3.0;
    protected double categorySpan;
    protected double categoryGapSpan;
    protected double itemSpan;
    protected double itemGapSpan;
    protected double itemWidth;
    protected double zeroInJava2D;
    protected double upperClip;
    protected double lowerClip;

    protected BarRenderer(CategoryToolTipGenerator toolTipGenerator) {
        super(toolTipGenerator);
    }

    public void initialise(Graphics2D g2, Rectangle2D dataArea, CategoryPlot plot, ValueAxis axis, CategoryDataset data, ChartRenderingInfo info) {
        this.info = info;
        this.lowerClip = axis.getRange().getLowerBound();
        this.upperClip = axis.getRange().getUpperBound();
    }

    public abstract int barWidthsPerCategory(CategoryDataset var1);

    public abstract boolean hasItemGaps();

    public boolean isStacked() {
        return false;
    }

    protected void calculateCategoryAndItemSpans(Graphics2D g2, Rectangle2D dataArea, CategoryPlot plot, CategoryDataset data, double span) {
        int seriesCount = data.getSeriesCount();
        int categoryCount = data.getCategoryCount();
        this.categorySpan = 0.0;
        this.categoryGapSpan = 0.0;
        if (categoryCount > 1) {
            double used = 1.0 - plot.getIntroGapPercent() - plot.getTrailGapPercent() - plot.getCategoryGapsPercent();
            this.categorySpan = span * used;
            this.categoryGapSpan = span * plot.getCategoryGapsPercent();
        } else {
            double used = 1.0 - plot.getIntroGapPercent() - plot.getTrailGapPercent();
            this.categorySpan = span * used;
        }
        this.itemSpan = this.categorySpan;
        this.itemGapSpan = 0.0;
        if (seriesCount > 1 && this.hasItemGaps()) {
            this.itemGapSpan = span * plot.getItemGapsPercent();
            this.itemSpan -= this.itemGapSpan;
        }
        this.itemWidth = this.itemSpan / (double)(categoryCount * this.barWidthsPerCategory(data));
        this.zeroInJava2D = plot.getRangeAxis().translateValueToJava2D(0.0, dataArea);
    }

    static {
        BAR_OUTLINE_WIDTH_THRESHOLD = 3.0;
    }
}

