/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AxisConstants;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.PlotNotCompatibleException;
import com.jrefinery.chart.Tick;
import com.jrefinery.chart.event.AxisChangeEvent;
import com.jrefinery.chart.event.AxisChangeListener;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class Axis
implements AxisConstants {
    protected boolean visible;
    protected String label;
    protected Font labelFont;
    protected Paint labelPaint;
    protected Insets labelInsets;
    protected boolean tickLabelsVisible;
    protected Font tickLabelFont;
    protected Paint tickLabelPaint;
    protected Insets tickLabelInsets;
    protected boolean tickMarksVisible;
    protected Stroke tickMarkStroke;
    protected List ticks;
    protected List listeners;
    protected Plot plot;
    protected double fixedDimension;

    protected Axis(String label) {
        this(label, AxisConstants.DEFAULT_AXIS_LABEL_FONT, AxisConstants.DEFAULT_AXIS_LABEL_PAINT, AxisConstants.DEFAULT_AXIS_LABEL_INSETS, true, AxisConstants.DEFAULT_TICK_LABEL_FONT, AxisConstants.DEFAULT_TICK_LABEL_PAINT, AxisConstants.DEFAULT_TICK_LABEL_INSETS, true, AxisConstants.DEFAULT_TICK_STROKE);
    }

    protected Axis(String label, Font labelFont, Paint labelPaint, Insets labelInsets, boolean tickLabelsVisible, Font tickLabelFont, Paint tickLabelPaint, Insets tickLabelInsets, boolean tickMarkVisible, Stroke tickMarkStroke) {
        this.label = label;
        this.labelFont = labelFont;
        this.labelPaint = labelPaint;
        this.labelInsets = labelInsets;
        this.tickLabelsVisible = tickLabelsVisible;
        this.tickLabelFont = tickLabelFont;
        this.tickLabelPaint = tickLabelPaint;
        this.tickLabelInsets = tickLabelInsets;
        this.tickMarksVisible = this.tickMarksVisible;
        this.tickMarkStroke = tickMarkStroke;
        this.ticks = new ArrayList();
        this.listeners = new ArrayList();
        this.visible = true;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean flag) {
        if (flag != this.visible) {
            this.visible = flag;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        String existing = this.label;
        if (existing != null) {
            if (!existing.equals(label)) {
                this.label = label;
                this.notifyListeners(new AxisChangeEvent(this));
            }
        } else if (label != null) {
            this.label = label;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Axis.setLabelFont(...): null not permitted.");
        }
        if (!this.labelFont.equals(font)) {
            this.labelFont = font;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public Paint getLabelPaint() {
        return this.labelPaint;
    }

    public void setLabelPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Axis.setLabelPaint(...): null not permitted.");
        }
        if (!this.labelPaint.equals(paint)) {
            this.labelPaint = paint;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public Insets getLabelInsets() {
        return this.labelInsets;
    }

    public void setLabelInsets(Insets insets) {
        if (!insets.equals(this.labelInsets)) {
            this.labelInsets = insets;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public boolean isTickLabelsVisible() {
        return this.tickLabelsVisible;
    }

    public void setTickLabelsVisible(boolean flag) {
        if (flag != this.tickLabelsVisible) {
            this.tickLabelsVisible = flag;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public Font getTickLabelFont() {
        return this.tickLabelFont;
    }

    public void setTickLabelFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Axis.setTickLabelFont(...): null not permitted.");
        }
        if (!this.tickLabelFont.equals(font)) {
            this.tickLabelFont = font;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public Paint getTickLabelPaint() {
        return this.tickLabelPaint;
    }

    public void setTickLabelPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Axis.setTickLabelPaint(...): null not permitted.");
        }
        if (!this.tickLabelPaint.equals(paint)) {
            this.tickLabelPaint = paint;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public Insets getTickLabelInsets() {
        return this.tickLabelInsets;
    }

    public void setTickLabelInsets(Insets insets) {
        if (insets == null) {
            throw new IllegalArgumentException("Axis.setTickLabelInsets(...): null not permitted.");
        }
        if (!this.tickLabelInsets.equals(insets)) {
            this.tickLabelInsets = insets;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public boolean isTickMarksVisible() {
        return this.tickMarksVisible;
    }

    public void setTickMarksVisible(boolean flag) {
        if (flag != this.tickMarksVisible) {
            this.tickMarksVisible = flag;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public Stroke getTickMarkStroke() {
        return this.tickMarkStroke;
    }

    public void setTickMarkStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Axis.setTickMarkStroke(...): null not permitted.");
        }
        if (!this.tickMarkStroke.equals(stroke)) {
            this.tickMarkStroke = stroke;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public Plot getPlot() {
        return this.plot;
    }

    public void setPlot(Plot plot) throws PlotNotCompatibleException {
        if (!this.isCompatiblePlot(plot) && plot != null) {
            throw new PlotNotCompatibleException("Axis.setPlot(...): plot not compatible with axis.");
        }
        this.plot = plot;
        this.configure();
    }

    public double getFixedDimension() {
        return this.fixedDimension;
    }

    public void setFixedDimension(double dimension) {
        this.fixedDimension = dimension;
    }

    public abstract void draw(Graphics2D var1, Rectangle2D var2, Rectangle2D var3);

    public abstract void refreshTicks(Graphics2D var1, Rectangle2D var2, Rectangle2D var3);

    public abstract void configure();

    protected double getMaxTickLabelWidth(Graphics2D g2, Rectangle2D plotArea) {
        double maxWidth = 0.0;
        Font font = this.getTickLabelFont();
        FontRenderContext frc = g2.getFontRenderContext();
        Iterator iterator = this.ticks.iterator();
        while (iterator.hasNext()) {
            Tick tick = (Tick)iterator.next();
            Rectangle2D labelBounds = font.getStringBounds(tick.getText(), frc);
            if (!(labelBounds.getWidth() > maxWidth)) continue;
            maxWidth = labelBounds.getWidth();
        }
        return maxWidth;
    }

    protected abstract boolean isCompatiblePlot(Plot var1);

    protected void notifyListeners(AxisChangeEvent event) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            AxisChangeListener listener = (AxisChangeListener)iterator.next();
            listener.axisChanged(event);
        }
    }

    public void addChangeListener(AxisChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangeListener(AxisChangeListener listener) {
        this.listeners.remove(listener);
    }
}

