/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AbstractXYItemRenderer;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.CrosshairInfo;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.XYItemRenderer;
import com.jrefinery.chart.XYPlot;
import com.jrefinery.chart.entity.EntityCollection;
import com.jrefinery.chart.entity.XYItemEntity;
import com.jrefinery.chart.tooltips.XYToolTipGenerator;
import com.jrefinery.data.XYDataset;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class AreaXYItemRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer {
    public static final int SHAPES = 1;
    public static final int LINES = 2;
    public static final int SHAPES_AND_LINES = 3;
    public static final int AREA = 4;
    public static final int AREA_AND_SHAPES = 5;
    protected boolean plotShapes;
    protected boolean plotLines;
    protected boolean plotArea;
    protected double shapeScale = 6.0;
    protected boolean showOutline;
    protected double zeroToJava2D;
    protected Line2D line;
    protected Polygon pArea = null;

    public AreaXYItemRenderer() {
        this(4);
    }

    public AreaXYItemRenderer(int type) {
        this(type, null);
    }

    public AreaXYItemRenderer(int type, XYToolTipGenerator toolTipGenerator) {
        super(toolTipGenerator);
        if (type == 1) {
            this.plotShapes = true;
        }
        if (type == 2) {
            this.plotLines = true;
        }
        if (type == 3) {
            this.plotShapes = true;
            this.plotLines = true;
        }
        if (type == 4) {
            this.plotArea = true;
        }
        if (type == 5) {
            this.plotArea = true;
            this.plotShapes = true;
        }
        this.line = new Line2D.Double(0.0, 0.0, 0.0, 0.0);
        this.showOutline = false;
    }

    public boolean isOutline() {
        return this.showOutline;
    }

    public void setOutline(boolean show) {
        this.showOutline = show;
    }

    public boolean getPlotShapes() {
        return this.plotShapes;
    }

    public boolean getPlotLines() {
        return this.plotLines;
    }

    public boolean getPlotArea() {
        return this.plotArea;
    }

    public void initialise(Graphics2D g2, Rectangle2D dataArea, XYPlot plot, XYDataset data, ChartRenderingInfo info) {
        super.initialise(g2, dataArea, plot, data, info);
        ValueAxis rangeAxis = plot.getRangeAxis();
        this.zeroToJava2D = rangeAxis.translateValueToJava2D(0.0, dataArea);
    }

    public void drawItem(Graphics2D g2, Rectangle2D dataArea, ChartRenderingInfo info, XYPlot plot, ValueAxis horizontalAxis, ValueAxis verticalAxis, XYDataset data, int series, int item, CrosshairInfo crosshairInfo) {
        EntityCollection entities;
        int itemCount = data.getItemCount(series);
        Paint seriesPaint = plot.getSeriesPaint(series);
        Stroke seriesStroke = plot.getSeriesStroke(series);
        g2.setPaint(seriesPaint);
        g2.setStroke(seriesStroke);
        Number x1 = data.getXValue(series, item);
        Number y1 = data.getYValue(series, item);
        double transX1 = horizontalAxis.translateValueToJava2D(x1.doubleValue(), dataArea);
        double transY1 = verticalAxis.translateValueToJava2D(y1.doubleValue(), dataArea);
        if (item == 0) {
            this.pArea = new Polygon();
            double transY2 = verticalAxis.translateValueToJava2D(0.0, dataArea);
            this.pArea.addPoint((int)transX1, (int)transY2);
        }
        this.pArea.addPoint((int)transX1, (int)transY1);
        Shape shape = null;
        if (this.plotShapes) {
            shape = plot.getShape(series, item, transX1, transY1, this.shapeScale);
            g2.draw(shape);
        } else {
            shape = new Rectangle2D.Double(transX1 - 2.0, transY1 - 2.0, 4.0, 4.0);
        }
        if (this.plotLines && item > 0) {
            Number x0 = data.getXValue(series, item - 1);
            Number y0 = data.getYValue(series, item - 1);
            double transX0 = horizontalAxis.translateValueToJava2D(x0.doubleValue(), dataArea);
            double transY0 = verticalAxis.translateValueToJava2D(y0.doubleValue(), dataArea);
            this.line.setLine(transX0, transY0, transX1, transY1);
            g2.draw(this.line);
        }
        if (this.plotArea && item > 0 && item == itemCount - 1) {
            double transY2 = verticalAxis.translateValueToJava2D(0.0, dataArea);
            this.pArea.addPoint((int)transX1, (int)transY2);
            g2.fill(this.pArea);
            if (this.showOutline) {
                g2.setStroke(plot.outlineStroke);
                g2.setPaint(plot.outlinePaint);
                g2.draw(this.pArea);
            }
        }
        if (horizontalAxis.isCrosshairLockedOnData()) {
            if (verticalAxis.isCrosshairLockedOnData()) {
                crosshairInfo.updateCrosshairPoint(x1.doubleValue(), y1.doubleValue());
            } else {
                crosshairInfo.updateCrosshairX(x1.doubleValue());
            }
        } else if (verticalAxis.isCrosshairLockedOnData()) {
            crosshairInfo.updateCrosshairY(y1.doubleValue());
        }
        if (this.info != null && (entities = this.info.getEntityCollection()) != null && shape != null) {
            String tip = "";
            if (this.toolTipGenerator != null) {
                tip = this.toolTipGenerator.generateToolTip(data, series, item);
            }
            XYItemEntity entity = new XYItemEntity(shape, tip, series, item);
            entities.addEntity(entity);
        }
    }

    static {
        SHAPES = 1;
        LINES = 2;
        SHAPES_AND_LINES = 3;
        AREA = 4;
        AREA_AND_SHAPES = 5;
    }
}

