/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.CategoryItemRenderer;
import com.jrefinery.chart.CategoryPlot;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.tooltips.CategoryToolTipGenerator;
import com.jrefinery.chart.tooltips.StandardCategoryToolTipGenerator;
import com.jrefinery.data.CategoryDataset;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;

public abstract class AbstractCategoryItemRenderer
implements CategoryItemRenderer {
    protected ChartRenderingInfo info;
    protected CategoryToolTipGenerator toolTipGenerator;

    protected AbstractCategoryItemRenderer() {
        this(new StandardCategoryToolTipGenerator());
    }

    protected AbstractCategoryItemRenderer(CategoryToolTipGenerator toolTipGenerator) {
        this.toolTipGenerator = toolTipGenerator;
        this.info = null;
    }

    public CategoryToolTipGenerator getToolTipGenerator() {
        return this.toolTipGenerator;
    }

    public void setToolTipGenerator(CategoryToolTipGenerator toolTipGenerator) {
        this.toolTipGenerator = toolTipGenerator;
    }

    public void initialise(Graphics2D g2, Rectangle2D dataArea, CategoryPlot plot, ValueAxis axis, CategoryDataset data, ChartRenderingInfo info) {
        this.info = info;
    }

    public boolean isStacked() {
        return false;
    }

    public Rectangle2D getAxisArea(Rectangle2D plotArea) {
        return plotArea;
    }

    public Shape getDataClipRegion(Rectangle2D dataArea) {
        return dataArea;
    }

    public void drawPlotBackground(Graphics2D g2, CategoryPlot plot, Rectangle2D axisDataArea, Shape dataClipRegion) {
        if (plot.getBackgroundPaint() != null) {
            g2.setPaint(plot.getBackgroundPaint());
            g2.fill(dataClipRegion);
        }
        if (plot.getOutlineStroke() != null && plot.getOutlinePaint() != null) {
            g2.setStroke(plot.getOutlineStroke());
            g2.setPaint(plot.getOutlinePaint());
            g2.draw(dataClipRegion);
        }
    }
}

