// This source file defines methods of the class
//    CParamDef
//


#include <assert.h>
#include <iostream>
#include <fstream>
//#include <iomanip>
#include <sstream>
//#include <stdlib.h>
//#include <stdio.h>
#include <string.h>

#include <ParamDef.hh>


//_________________________________________________________
//
// CParamDef                                           
//_________________________________________________________

CParamDef::CParamDef (char *keywordInit,
		      char flagInit,
		      types partypeInit,
		      char *partypenameInit,
		      char *descriptionInit,
		      char *errordescInit,
		      bool optInit,
		      int acceptWithoutKeywordOrder)
{
  keyword     = new char[strlen(keywordInit)+1];
  assert (keyword); 
  strcpy(keyword, keywordInit);
  flag        = flagInit;
  partype     = partypeInit;
  partypename = partypenameInit;
  description = new char[strlen(descriptionInit)+1];
  assert (description); 
  strcpy(description, descriptionInit);
  errordesc   = new char[strlen(errordescInit)+1];
  assert (errordesc); 
  strcpy(errordesc, errordescInit);
  opt         = optInit;
  acceptOrder = acceptWithoutKeywordOrder;
  
  if (opt)
    satisfied = true;
  else
    satisfied = false;

  paramFileName = NULL;
} // CParamDef::CParamDef
//_________________________________________________________

CParamDef::~CParamDef()
{
 delete [] keyword; delete [] description; delete [] errordesc;
}
//_________________________________________________________

int CParamDef::dealWith (char *token, char *source)
{
  if ( !getVarFromToken( token ) )
    {  
      std::cerr << std::endl << "'" << token << "' " << errordesc << std::endl;
      // occasion to use rcsid
      // std::cerr << std::endl << " var: " << *var;
      exit(-1);  // this avoids segmentation fault
      return 0;
    }
  else
    {
      satisfied = true;
      // note that source is NOT stcpy's
      paramFileName = source;
      return 1;
    }
}

//_________________________________________________________

int CParamDef::understands (char c)
{
  return ( ((c == flag) && (flag)) ? true : false);
}
//_________________________________________________________


int CParamDef::understands (char *ptr) 
{
  return ( !strcmp(ptr, keyword) );
}
//_________________________________________________________


void CParamDef::writeDataType()
{
  std::cerr << partypename;
}

void CParamDef::usageInfo ()
  // prints the param.s flag and keyword; in [] if optional
{
  if (no_keyword())
    {
      // No keyword
      if (opt)
	{
	  std::cerr << " [";
	  writeDataType();
	  std::cerr << "]";
	}
      else
	{
	  std::cerr << " ";
	  writeDataType();
	}
    }
  else
    {
      if (flag)
	{
	  if (opt)
	    {
	      std::cerr <<  " [-" << flag << " ";
	      writeDataType();
	      std::cerr << "]";
	    }
	  else
	    {
	      std::cerr <<  " -" << flag << " ";
	      writeDataType();
	    }
	}
    }
}

//_________________________________________________________


void CParamDef::writeDesc ()
{
  std::cerr << std::endl << "   ";
  if (no_keyword())
    {
      // no keyword
      writeDataType();
    }
  else
    {
      // keyword
      if (flag) 
	{
	  std::cerr << "-" << flag << " ";
	  writeDataType();
	  std::cerr << ", ";
	}
      std::cerr << "--" << keyword << "=";
      writeDataType();
    }
  std::cerr << ":" << std::endl << "\t\t" << description;
  if ( optional() )
    {
     std::cerr <<  std::endl << "\t\t" << "Default: ";
     writeDefault();
    }
  else
    {
     std::cerr <<  std::endl << "\t\t" << "!! This parameter MUST be given !!";
    }
  if (no_keyword())
    {
      // no keyword
      std::cerr << std::endl << "\t\tKeyword in parameter file: " << keyword;
    }
}

bool CParamDef::myKWless_param(int nr)
{
  if (nr ==  acceptOrder) return true;
  else return false;
}

bool CParamDef::no_keyword()
{
  if (acceptOrder == -1) return false;
  else return true;
}


//_________________________________________________________
//
// CCharParamDef
//_________________________________________________________

CCharParamDef::CCharParamDef (char *keywordInit,
			      char flagInit,
			      char  *varInit,
			      char  defltInit,
			      char *partypenameInit,
			      char *descriptionInit,
			      bool optInit,
			      int acceptWithoutKeywordOrder)
: CParamDef (keywordInit, flagInit, 
	     Char, partypenameInit, descriptionInit, 
	     "should be a character", 
	     optInit, acceptWithoutKeywordOrder)
{
  var = varInit; deflt = defltInit; *var = deflt;
};
//_________________________________________________________


//! Print keyword=value to output stream.
void CCharParamDef::display(std::ostream & os) const {
  assert(keyword);
  assert(var);
  os << keyword << "=" << *var << std::endl;
} // param def display()

int CCharParamDef::getVarFromToken (char *token)
{
  if (!token)
    return 0;
  std::istringstream Token (token);

  Token >> *var;
  return ( !Token.fail() );
}

//_________________________________________________________
//
// CBoolParamDef
//_________________________________________________________

CBoolParamDef::CBoolParamDef (char *keywordInit,
			      char flagInit,
			      bool *varInit,
			      bool  defltInit,
			      char *partypenameInit,
			      char *descriptionInit,
			      bool optInit,
			      int acceptWithoutKeywordOrder)
: CParamDef (keywordInit, flagInit, Bool, partypenameInit, descriptionInit, "", 
	     optInit, acceptWithoutKeywordOrder)
{
  var = varInit; deflt = defltInit; *var = deflt;
};
//_________________________________________________________

int CBoolParamDef::dealWith (char * /*token*/, char *source)
{
  *var = true;
  satisfied = true;
  // note that source is NOT stcpy's
  paramFileName = source;
  return 1; 
}
//_________________________________________________________

void CBoolParamDef::usageInfo ()
{
  if (flag) std::cerr << flag;
}
//_________________________________________________________

void CBoolParamDef::writeDesc ()
{
  if (flag) std::cerr << "\n   -" << flag << ", --" << keyword << ":\n\t\t" << description;
  else std::cerr << "\n   --" << keyword << ":\n\t\t" << description;
}

bool CBoolParamDef::myKWless_param(int nr)
{
  if (nr == -1) return true;
  else return false;
}

bool CBoolParamDef::no_keyword()
{
  return false;
}

//! Print keyword=value to output stream.
void CBoolParamDef::display(std::ostream & os) const {
  assert(keyword);
  assert(var);
  os << keyword << "=" << *var << std::endl;
} // param def display()

//_________________________________________________________
//
// CIntParamDef
//_________________________________________________________

CIntParamDef::CIntParamDef (char *keywordInit,
			    char flagInit,
			    int  *varInit,
			    int  defltInit,
			    char *partypenameInit,
			    char *descriptionInit,
			    bool optInit,
			    int acceptWithoutKeywordOrder)
: CParamDef (keywordInit, flagInit, 
	     Int, partypenameInit, descriptionInit, 
	     "should be an integer",
	     optInit, acceptWithoutKeywordOrder)
{
  var = varInit; deflt = defltInit; *var = deflt;
};
//_________________________________________________________

//! Print keyword=value to output stream.
void CIntParamDef::display(std::ostream & os) const {
  assert(keyword);
  assert(var);
  os << keyword << "=" << *var << std::endl;
} // param def display()

int CIntParamDef::getVarFromToken (char *token)
{
  if (!token)
    return 0;
  std::istringstream Token (token);

  Token >> *var;
  return ( !Token.fail() );
}

//_________________________________________________________
//
// CUnsignedintParamDef
//_________________________________________________________

CUnsignedintParamDef::CUnsignedintParamDef (char *keywordInit,
					    char flagInit,
					    unsigned int  *varInit,
					    unsigned int  defltInit,
					    char *partypenameInit,
					    char *descriptionInit,
					    bool optInit,
					    int acceptWithoutKeywordOrder)
: CParamDef (keywordInit, flagInit, 
	     Unsignedint, partypenameInit, descriptionInit, 
	     "should be an unsigned integer",
	     optInit, acceptWithoutKeywordOrder)
{
  var = varInit; deflt = defltInit; *var = deflt;
};
//_________________________________________________________

//! Print keyword=value to output stream.
void CUnsignedintParamDef::display(std::ostream & os) const {
  assert(keyword);
  assert(var);
  os << keyword << "=" << *var << std::endl;
} // param def display()

int CUnsignedintParamDef::getVarFromToken (char *token)
{
  if (!token)
    return 0;

  std::istringstream Token (token);

  Token >> *var;
  return ( !Token.fail() );
}

//_________________________________________________________
//
// CShortintParamDef
//_________________________________________________________

CShortintParamDef::CShortintParamDef (char *keywordInit,
				      char flagInit,
				      short int  *varInit,
				      short int  defltInit,
				      char *partypenameInit,
				      char *descriptionInit,
				      bool optInit,
				      int acceptWithoutKeywordOrder)
: CParamDef (keywordInit, flagInit, 
	     Shortint, partypenameInit, descriptionInit, 
	     "should be a (short) integer",
	     optInit, acceptWithoutKeywordOrder)
{
  var = varInit; deflt = defltInit; *var = deflt;
};
//_________________________________________________________

//! Print keyword=value to output stream.
void CShortintParamDef::display(std::ostream & os) const {
  assert(keyword);
  assert(var);
  os << keyword << "=" << *var << std::endl;
} // param def display()

int CShortintParamDef::getVarFromToken (char *token)
{
  if (!token)
    return 0;

  std::istringstream Token (token);

  Token >> *var;
  return ( !Token.fail() );
}

//_________________________________________________________
//
// CUnsignedshortParamDef
//_________________________________________________________

CUnsignedshortParamDef::CUnsignedshortParamDef (char *keywordInit,
						char flagInit,
						unsigned short int  *varInit,
						unsigned short int  defltInit,
						char *partypenameInit,
						char *descriptionInit,
						bool optInit,
						int acceptWithoutKeywordOrder)
: CParamDef (keywordInit, flagInit, 
	     Unsignedshort, partypenameInit, descriptionInit, 
	     "should be an unsigned integer",
	     optInit, acceptWithoutKeywordOrder)
{
  var = varInit; deflt = defltInit; *var = deflt;
};
//_________________________________________________________

//! Print keyword=value to output stream.
void CUnsignedshortParamDef::display(std::ostream & os) const {
  assert(keyword);
  assert(var);
  os << keyword << "=" << *var << std::endl;
} // param def display()

int CUnsignedshortParamDef::getVarFromToken (char *token)
{
  if (!token)
    return 0;

  std::istringstream Token (token);

  Token >> *var;
  return ( !Token.fail() );
}

//_________________________________________________________
//
// CLongintParamDef
//_________________________________________________________

CLongintParamDef::CLongintParamDef (char *keywordInit,
				    char flagInit,
				    long int  *varInit,
				    long int  defltInit,
			  	    char *partypenameInit,
				    char *descriptionInit,
				    bool optInit,
				    int acceptWithoutKeywordOrder)
  : CParamDef (keywordInit, flagInit, 
	       Longint, partypenameInit, descriptionInit, 
	       "should be an integer",
	       optInit, acceptWithoutKeywordOrder)
{
  var = varInit; deflt = defltInit; *var = deflt;
};
//_________________________________________________________

//! Print keyword=value to output stream.
void CLongintParamDef::display(std::ostream & os) const {
  assert(keyword);
  assert(var);
  os << keyword << "=" << *var << std::endl;
} // param def display()

int CLongintParamDef::getVarFromToken (char *token)
{
  if (!token)
    return 0;

  std::istringstream Token (token);

  Token >> *var;
  return ( !Token.fail() );
}

//_________________________________________________________
//
// CUnsignedlongParamDef
//_________________________________________________________

CUnsignedlongParamDef::CUnsignedlongParamDef (char *keywordInit,
					      char flagInit,
					      unsigned long int  *varInit,
					      unsigned long int  defltInit,
					      char *partypenameInit,
					      char *descriptionInit,
					      bool optInit,
					      int acceptWithoutKeywordOrder)
: CParamDef (keywordInit, flagInit, 
	     Unsignedlong, partypenameInit, descriptionInit, 
	     "should be an unsigned integer",
	     optInit, acceptWithoutKeywordOrder)
{
  var = varInit; deflt = defltInit; *var = deflt;
};
//_________________________________________________________

//! Print keyword=value to output stream.
void CUnsignedlongParamDef::display(std::ostream & os) const {
  assert(keyword);
  assert(var);
  os << keyword << "=" << *var << std::endl;
} // param def display()

int CUnsignedlongParamDef::getVarFromToken (char *token)
{
  if (!token)
    return 0;

  std::istringstream Token (token);

  Token >> *var;
  return ( !Token.fail() );
}


//_________________________________________________________
//
// CStringParamDef
//_________________________________________________________

CStringParamDef::CStringParamDef (char *keywordInit,
				  char flagInit,
				  char  **varInit,
				  char  *defltInit,
				  char *partypenameInit,
				  char *descriptionInit,
				  bool optInit,
				  int acceptWithoutKeywordOrder)
: CParamDef (keywordInit, flagInit, 
	     String, partypenameInit, descriptionInit, 
	     "should be a non null string",
	     optInit, acceptWithoutKeywordOrder)
{
  varToBeDeleted = false;
  var = varInit; deflt = defltInit; *var = deflt;
};
//_________________________________________________________

CStringParamDef::~CStringParamDef()
{
  if (varToBeDeleted)
    delete [] *var;
}
//_________________________________________________________

//! Print keyword=value to output stream.
void CStringParamDef::display(std::ostream & os) const {
  assert(keyword);
  assert(var);
  if (*var != NULL)
    os << keyword << "=" << *var << std::endl;
  else
    os << keyword << "=" << std::endl;
} // param def display()

int CStringParamDef::getVarFromToken (char *token)
{
  if (!token)
    return 0;

  varToBeDeleted = true;
  *var = new char[strlen (token)+1];
  //EXIT_IF (!(*var), "could not allocate memory for String parameter", -1);
  if (!(*var)){
    std::cerr<<"could not allocate memory for String parameter"<<std::endl;
    exit(-1);
  }
  strcpy (*var, token);
  return strlen (token);
}


//_________________________________________________________
//
// CDoubleParamDef
//_________________________________________________________

CDoubleParamDef::CDoubleParamDef (char *keywordInit,
				  char flagInit,
				  double  *varInit,
				  double  defltInit,
				  char *partypenameInit,
				  char *descriptionInit,
				  bool optInit,
				  int acceptWithoutKeywordOrder)
: CParamDef (keywordInit, flagInit, 
	     Double, partypenameInit, descriptionInit, 
	     "should be a double",
	     optInit, acceptWithoutKeywordOrder)
{
  var = varInit; deflt = defltInit; *var = deflt;
};
//_________________________________________________________

//! Print keyword=value to output stream.
void CDoubleParamDef::display(std::ostream & os) const {
  assert(keyword);
  assert(var);
  os << keyword << "=" << *var << std::endl;
} // param def display()

int CDoubleParamDef::getVarFromToken (char *token)
{
  if (!token)
    return 0;

  std::istringstream Token (token);

  Token >> *var;
  return (! Token.fail()); // Token.eof seems to be set after reading for double
                           // or float... So Token.good is zero...
}
//_________________________________________________________
//
// CFloatParamDef
//_________________________________________________________

CFloatParamDef::CFloatParamDef (char *keywordInit,
				char flagInit,
				float  *varInit,
				float  defltInit,
				char *partypenameInit,
				char *descriptionInit,
				bool optInit,
				int acceptWithoutKeywordOrder)
: CParamDef (keywordInit, flagInit, 
	     Float, partypenameInit, descriptionInit, 
	     "should be a float",
	     optInit, acceptWithoutKeywordOrder)
{
  var = varInit; deflt = defltInit; *var = deflt;
};
//_________________________________________________________

//! Print keyword=value to output stream.
void CFloatParamDef::display(std::ostream & os) const {
  assert(keyword);
  assert(var);
  os << keyword << "=" << *var << std::endl;
} // param def display()

int CFloatParamDef::getVarFromToken (char *token)
{
  if (!token)
    return 0;

  std::istringstream Token (token);

  Token >> *var;
  return ( !Token.fail() );
}








