%%
%% Style file for TMI-02
%%
%% identification
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{tmi02}
%
%% initial Code
%%
\newif\if@submit
\@submitfalse
%%
%% options
%%
\LoadClass[a4paper,11pt,oneside,onecolumn]{article}
%\OptionNotUsed{10pt,12pt,twoside,titlepage}
%\PassOptionsToClass{article}
\DeclareOption{submit}{\@submittrue\setlength\overfullrule{0pt}}
\DeclareOption{final}{\@submitfalse\setlength\overfullrule{0pt}%
\pagestyle{empty}}
%\ExecuteOptions{final}
\ProcessOptions

%\newcommand*{\email}[1]{\def\@email{#1}}
%\newcommand*{\address}[1]{\def\@address{#1}}
%\newcommand*{\institute}[1]{\def\@institute{#1}}
\newcommand{\email}[1]{\def\@email{#1}}
\newcommand{\address}[1]{\def\@address{#1}}
\newcommand{\institute}[1]{\def\@institute{#1}}
\email{}
\address{}
\institute{}
%%% titlepage
\if@submit
%%% if submission, make anonymous
\renewcommand{\@maketitle}{%
%%% make id page with names and addresses ...
\newpage
\null 
\vspace*{12ex}%
\begin{center}%
\large \textbf{ID Page}\\[2ex]
{\LARGE \@title \par}%
\vskip 2ex%
\lineskip .5em%
\@author\\\@institute\\\@address\\\texttt{\@email}
\end{center}
% don't give the idpage a number
\thispagestyle{empty}\setcounter{page}{0}%
\newpage
%%% suppress names and addresses in the paper itself
\null %%%%%
\vspace*{-2ex}%
\begin{center}%
{\LARGE \@title \par}%
\vskip 2ex%
\lineskip .5em% 
Author(s) hidden for anonymous review\\
\small Institute also hidden\\
\small Address also hidden\\
\small (probably two lines)\\
\small Email also hidden
\end{center}%
\par
\vskip 2ex}
\else
%%% else put title and all information on first page
\renewcommand{\@maketitle}{%
\newpage%
\null% 
\vspace*{-2ex}%
\begin{center}%
\let \footnote \thanks
{\LARGE \@title \par}%
\vskip 2ex%
\lineskip .5em% 
\@author\\%
\small\@institute\\%
\small\@address\\%
\small\texttt{\@email}%
\end{center}%
\par% 
\vskip 2ex}
\renewcommand{\maketitle}{\@maketitle\thispagestyle{empty}}
\fi

%------------------------------------------------------------------------
% Paper size
%
\oddsidemargin 0.71cm \evensidemargin 0.71cm
\marginparwidth 90pt
\marginparsep 11pt
\topmargin 11pt \headheight 12pt \headsep 13.66pt
%\footheight 12pt \footskip 30pt
\textwidth 14.5truecm
\textheight 22truecm
\columnsep 1cc \columnseprule 0pt

\@fptop 0pt plus 1fil \@fpsep 8pt plus 2fil \@fpbot 0pt plus 1fil
\@dblfptop0pt plus1fil \@dblfpsep8pt plus2fil\@dblfpbot 0pt plus1fil
\marginparpush 5pt

\parskip 3pt plus 3pt \parindent 1.5em \topsep 8pt plus 2pt minus 4pt
\partopsep 2pt plus 1pt minus 1pt \itemsep \z@
\@lowpenalty 51 \@medpenalty 151 \@highpenalty 301
\@beginparpenalty-\@lowpenalty\@endparpenalty -\@lowpenalty\@itempenalty
-\@lowpenalty



% ----------------------------------------------------------------------
% Section headings with less space
%
\def\section{%
    \@startsection{section}{1}{\z@}%
                  {-2.0ex plus -0.5ex minus -0.3ex}%
                  {0.8ex plus 0.3ex minus 0.2ex}%
                  {\Large\bf\raggedright}}
\def\subsection{%
    \@startsection{subsection}{2}{\z@}%
                  {-1.4ex plus -0.4ex minus -0.2ex}%
                  {0.6ex plus 0.2ex minus 0.1ex}%
                  {\large\bf\raggedright}}
\def\subsubsection{%
    \@startsection{subsubsection}{3}{\z@}%
                  {-0.8ex plus -0.3ex minus -0.1ex}%
                  {0.4ex plus 0.1ex minus 0.1ex}%
                  {\normalsize\bf\raggedright}}
\def\paragraph{%
    \@startsection{paragraph}{4}{\z@}%
                  {-0.8ex plus -0.3ex minus -0.1ex}%
                  {-1em}%
                  {\normalsize\bf}}
\def\subparagraph{%
    \@startsection{subparagraph}{5}{\parindent}%
                  {0.4ex plus 0.3ex minus 0.1ex}%
                  {-1em}%
                  {\normalsize\bf}}


%%%
%%% Citing stuff
%%%
%%% adapted from lsalike.sty

\newlength{\bibhang}
\setlength{\bibhang}{2em}
\def\thebibliography#1{\section*{\refname}%
  \small\list
  {\relax}{\setlength{\labelsep}{0em}
        \setlength{\itemindent}{-\bibhang}
        \setlength{\leftmargin}{\bibhang}}
    \def\newblock{\hskip .11em plus .33em minus .07em}
    \sloppy\clubpenalty4000\widowpenalty4000
    \sfcode`\.=1000\relax}
\let\@internalcite\cite

\def\xcite{\def\@citeseppen{-1000}%
 \def\@cite##1##2{(\nobreak\hskip 0in{##1\if@tempswa , ##2\fi})}%
 \def\citeauthoryear##1##2{\frenchspacing##1 ##2}\@internalcite}

\def\xpagecite[#1]#2{\def\@citeseppen{-1000}%
 \def\@cite##1##2{(\nobreak\hskip 0in{##1\if@tempswa , ##2\fi})}%
 \def\citeauthoryear##1##2{\frenchspacing##1 ##2:#1}\@internalcite{#2}}

\def\cite{\@ifnextchar [{\xpagecite}{\xcite}}

\def\xnamecite{\def\@citeseppen{1000}%
 \def\@cite##1##2{{##1\if@tempswa , ##2\fi}}%
 \def\citeauthoryear##1##2{\frenchspacing##1 (##2)}\@internalcite}

\def\xnamepagecite[#1]#2{\def\@citeseppen{1000}%
 \def\@cite##1##2{{##1\if@tempswa , ##2\fi}}%
 \def\citeauthoryear##1##2{\frenchspacing##1 (##2:#1)}\@internalcite{#2}}

\def\namecite{\@ifnextchar [{\xnamepagecite}{\xnamecite}}

\def\xquotecite{\def\@citeseppen{1000}%
 \def\@cite##1##2{{##1\if@tempswa , ##2\fi}}%
 \def\citeauthoryear##1##2{\frenchspacing##1's (##2)}\@internalcite}

\def\xquotepagecite[#1]#2{\def\@citeseppen{1000}%
 \def\@cite##1##2{{##1\if@tempswa , ##2\fi}}%
 \def\citeauthoryear##1##2{\frenchspacing##1's (##2:#1)}\@internalcite{#2}}

\def\quotecite{\@ifnextchar [{\xquotepagecite}{\xquotecite}}

\def\citeboth{\def\@citeseppen{1000}%
 \def\@cite##1##2{{##1\if@tempswa , ##2\fi}}%
 \def\citeauthoryear##1##2{\frenchspacing##1 ##2}\@internalcite}

% \def\item{\@ifnextchar [{\@item}{\@noitemargtrue \@item[\@itemlabel]}}


\def\citeauthor#1{\def\@cite##1##2{{##1\if@tempswa , ##2\fi}}%
 \def\citeauthoryear##1##2{\frenchspacing##1}\@citedata{#1}}

\def\citeyear#1{\def\@cite##1##2{{##1\if@tempswa , ##2\fi}}%
 \def\citeauthoryear##1##2{##2}\@citedata{#1}}

\def\@citedata#1{\@tempswafalse%
 \if@filesw\immediate\write\@auxout{\string\citation{#1}}\fi
  \def\@citea{}\@cite{\@for\@citeb:=#1\do
    {\@citea\def\@citea{,\penalty\@citeseppen\ }\@ifundefined
       {b@\@citeb}{{\bf ?}\@warning
       {Citation `\@citeb' on page \thepage \space undefined}}%
{\csname b@\@citeb\endcsname}}}{}}

% don't box citations, separate with ; and a space
% also, make the penalty between citations negative: a good place to break
\def\@citex[#1]#2{\if@filesw\immediate\write\@auxout{\string\citation{#2}}\fi
  \def\@citea{}\@cite{\@for\@citeb:=#2\do
    {\@citea\def\@citea{;\penalty\@citeseppen\ }\@ifundefined
       {b@\@citeb}{{\bf ?}\@warning
       {Citation `\@citeb' on page \thepage \space undefined}}%
{\csname b@\@citeb\endcsname}}}{#1}}

% raise the brackets in bibliography labels
\def\@biblabel#1{}

%%%
%%% Linguistic citations
%%%

\DeclareRobustCommand{\citeform}%
{\@ifnextchar[{\@citeformglossx}{\@citeformx}}
\def\@citeformx#1{\textit{#1}}
\def\@citeformglossx[#1]#2{\textit{#2}\ ``#1''}


