;;; -*- Mode: Lisp -*-


;;; Multiple String Replacements    --    tk, 24-aug-89


#| Example
(make-reps "shipping cardboard" '((" " "_"))) ;dmg added 8-jan-90
(make-replacements "el billete a el hombre")
;; --> "el billete al hombre"     
;;     ( given the value of *replacements* below..)
|#;------------------------------------------------


;;; The set of replacements that are make are controlled by this list:

;(defvar *replacements* 
;    '((" de el " " del ") (" a el " " al ") ("De el " "Del ") ("A el " "Al ") 
;      ("^" "1") ("+" "1") ("++" "2") ("+++" "3") ("^^^" "3") ("^^" "2"))
  "Each element of this list should be a list of two strings;
  the first string will be replaced by the other in the string given to
  make-replacements.")


;;; make-replacements and replace-string call each other recursively

(defun make-replacements (string)
  (dolist (r *replacements*)
    (setf string (replace-string string (first r)(second r)))
    )
  string)

(defun make-reps (string *reps*) ; dmg added so that the replacements could be
                                 ;specified at any time
  (dolist (r *reps*)
    (setf string (replace-string2 string (first r)(second r) *reps*))
    )
  string)


(defun replace-string2 (string old-substring new-substring reps)
  "If we find a pattern  <X> <old-substring> <Y>,  we return it with
   <X> <new-substring> <Y'>,
                  where Y' has the same set of string replacements applied
   to it."
  (let ((sub-position (find-substring old-substring string)))
    (cond ((null sub-position)
	   ;; no find, return unchanged
	   string) 
	  (t
	   ;; otherwise, return a new string
	   (concatenate 'string
			(string-first string sub-position)
			new-substring
			(make-reps (string-rest
				    string
				    (+ sub-position
				       (length old-substring))) reps))
	  )
    )
  )
)


(defun replace-string (string old-substring new-substring)
  "If we find a pattern  <X> <old-substring> <Y>,  we return it with
   <X> <new-substring> <Y'>,
                  where Y' has the same set of string replacements applied
   to it."
  (let ((sub-position (find-substring old-substring string)))
    (cond ((null sub-position)
	   ;; no find, return unchanged
	   string) 
	  (t
	   ;; otherwise, return a new string
	   (concatenate 'string
			(string-first string sub-position)
			new-substring
			(make-replacements (string-rest
					    string
					    (+ sub-position
					       (length old-substring)))))))))


;;; These are auxilliary functions used by replace-string:

(defun string-first (string index)
  "Returns the first part of string, up to the character at index."
  (subseq string 0 index))

(defun string-rest (string index)
  "Returns the rest of string, after the character at index."
  (subseq string index))


(defun find-substring (sub-string string)
  "If sub-string is within string, returns the position that it starts at"
  (do* ((position (position (schar sub-string 0) string :test #'char-equal)
		  (position (schar sub-string 0) string :test #'char-equal
			    :start (1+ position)))
	)
       ;; we guess first at the first matching character; if it does,
       ;; then we call find-substring-aux to make sure.
       ((or (null position)
	    (and position (find-substring-aux string sub-string position)))
	position)
    ))

(defun find-substring-aux (s1 s2 i)
  "Returns T iff s2 is a substring of s1 starting at position i."
  (dotimes (k (length s2)
	      ;; if we make it through, return T:
	      T)
    (when (or (>= (+ k i)  (length s1))
              (char-not-equal (schar s2    k)
		    	      (schar s1 (+ k i))))
      (return nil))))
