(defvar *if-lexicon-table* (make-hash-table :size 100007))
(defvar *DEBUG* nil)

;; Read a file of lexical entries with sem-value keys:
;; (night ((cat n) (root nacht) (gender feminine)))
;; (night ((cat tod) (root nacht) (gender feminine)))
;; or
;; (night ((cat n) (root nacht) (gender feminine))
;;        ((cat tod) (root nacht) (gender feminine)))
;;
(defun read-lex-file (input &key (clear t))
        (when clear (clrhash *if-lexicon-table*))
        (with-open-file (inp input :direction :input)
           (print "Reading IF Lexical Database!")           
           (do* ((entry (read inp nil :eof) (read inp nil :eof)))
                ((equal entry :eof) (print "Lexicon loaded!") t)
                (when *DEBUG* (print entry))
                (let ((db (gethash (car entry) *if-lexicon-table*)))
                  (if  db
                       (setf (gethash (car entry) *if-lexicon-table*)
                             (append db (cdr entry)))
                       (setf (gethash (car entry) *if-lexicon-table*) 
                        (cdr entry)))))))



;; Get the lexical fs based on POS/CAT and add sem-value to fs output
;; (get-lex 'night 'n)
;;  => ((sem-value night) (cat n) (root nacht) (gender feminine))
;; (get-lex 'night 'tod)
;;  => ((sem-value night) (cat tod) (root nacht) (gender feminine))
;;
(defun get-lex (val &optional (pos nil) &key (lex-id nil) (check nil) (ambiguity nil))
    (get-lex-fs val (if pos (list (list 'cat pos)) pos) :lex-id lex-id :ambiguity ambiguity :check check))

#| ;; old definition of get-lex
      (let* ((res  (gethash val *if-lexicon-table*))
             (out nil))
            (cond 
               ((and res pos)
                (do* ((fss res (cdr fss))
                      (fs nil))
                     ((or fs (null fss)) (setq out fs))
                     (when (member (list 'cat pos) (car fss) :test 'equal)
                         (setq fs (car fss)))))
               ((null pos)
                ;; if no POS given, take first thing in list
                (setq out (car res))))
            (cons (list 'sem-value val) out))
|#
           



;; Test this!
;; if req-fvs (required features value pairs or feature structure) 
;; are in lexical entry, return all lexical entries that match unless
;; ambiguity is nil, in which case, return first match.
;; if :check's value (a fv pair list or feature structure) is defined, 
;; use this to limit ambiguity, these features 
;; are not required but must match if defined in lexical entry.
;; (get-lex-fs (x0 sem-value) '((cat n)) :check '((arg object-spec)) :ambiguity t)
;; (get-lex-fs (x0 sem-value) (x0 temp) :check (x0 temp2) :ambiguity t :lex-id 'e)
;; (get-lex-fs (x0 sem-value) (x0 temp) :check (x0 temp2))

(defun get-lex-fs (val &optional (req-fvs nil) &key (lex-id nil) (check nil) (ambiguity nil))

      (let* ((res  (gethash val *if-lexicon-table*))
             (out nil))
            (when res
                (setq out (find-matching-fs req-fvs res :ambiguity ambiguity :check check)))
            (if (equal (car out) '*or*)
                (do* ((temp (cdr out) (cdr temp))
                      (new nil))
                     ((null temp) (cons '*or* new))
                     (setq new (append new
                                       (list (cons (list 'sem-value val) (car temp))))))
                (cons (list 'sem-value val) out))))
           

;; make sure the req features (fs) are present in the lex fs (fslist)
(defun find-matching-fs (fs fslist &key (ambiguity nil) (check nil))
          (when check (setq check (reduce-nils check)))
          (when fs (setq fs (reduce-nils fs)))

          (do* ((fsl fslist (cdr fsl))
                (temp (car fsl) (car fsl))
                (res nil))
               ((null fsl) (cond ((and ambiguity (> (length res) 1))
                                  (cons '*or* (reverse res)))
                                 (ambiguity (car res))
                                 (t res)))

               ;;(when temp (setq temp (reduce-nils temp)))
               (when (and (if temp (matching-fs-p fs temp) t)
                          (if check (optional-matching-fs-p check temp) t))
                     (cond (ambiguity (push temp res))
                           (t (setq res temp) (setq fsl nil))))))
                

(defun reduce-nils (fs)
         (let ((res nil))
             (dolist (av fs)
                 (when (second av)
                    (push av res)))
             res))


;; '((a ((x y))))
;; '(((a b)) ((c b) (a ((x y))) (x y)))
;; '(((a b)) ((c b) (a ((x y))) (x y)) ((a ((x y))) (b a)))
;; fs1 = req fvs, fs2 = lex fs
(defun matching-fs-p (fs1 fs2)
     "only match if fs1's feature values are in fs2"
           (do* ((fs fs1 (cdr fs))
                 (res fs2)
                 (fv (car fs) (car fs)))
                ((null fs) res)
                (cond ((or 
                          (member fv fs2 :test 'equal)
                          (and 
                           (consp (second fv))  ;; the case where we have 
                                                 ;; fs1= (agr ((number sg))) 
                                                 ;;fs2=((root book) (agr ((number sg))))

                            (let ((temp (member (first fv) fs2 :test '(lambda (a b) (equal a (car b))))))
                                  ;; if member succeeds we would get ((agr ((number sg))))
                              (and temp (matching-fs-p (second fv) (second (cdr temp)))))))
                      t)
                      ((matching-fv-p fv fs2)
                       t)
                      (t (setq res nil) (setq fs nil)))))


(defun optional-matching-fv-p (feat-val lex-feat-struct)
              (let ((feat-struct-val (second  (assoc (car feat-val) lex-feat-struct))))
                (cond  ((null feat-struct-val) t)
                       ((and (consp feat-struct-val) 
                            (equal (car feat-struct-val) '*or*)
                            (member (cadr feat-val) (cdr feat-struct-val)))
                       t)

                      ((and (consp feat-struct-val) 
                            (equal (car feat-struct-val) '*not*)
                            (not (member (cadr feat-val) (cdr feat-struct-val))))
                       t)
                      (t nil))))
                  




(defun matching-fv-p (feat-val lex-feat-struct)
              (let ((feat-struct-val (second  (assoc (car feat-val) lex-feat-struct))))
                (cond ((and (consp feat-struct-val) 
                            (equal (car feat-struct-val) '*or*)
                            (member (cadr feat-val) (cdr feat-struct-val)))
                       t)

                      ((and (consp feat-struct-val) 
                            (equal (car feat-struct-val) '*not*)
                            (not (member (cadr feat-val) (cdr feat-struct-val))))
                       t)
                      (t nil))))
                  




;; '((a ((x y))))
;; '(((a b)) ((c b) (a ((x y))) (x y)))
;; '(((a b)) ((c b) (a ((x y))) (x y)) ((a ((x y))) (b a)))
(defun optional-matching-fs-p (fs1 fs2)
     "match if fs1's feature values are in fs2 and have the same value \nor \nif the features in fs1 are not defined in fs2"
           (do* ((fs fs1 (cdr fs))
                 (res fs2)
                 (fv (car fs) (car fs)))
                ((null fs) res)
                (cond ((or 
                          (member fv fs2 :test 'equal)
                          (not (member (car fv) fs2 :test '(lambda (a b) (equal a (car b)))))
                          (and 
                           (consp (second fv))  ;; the case where we have 
                                                 ;; fs1= (agr ((number sg))) 
                                                 ;;fs2=((root book) (agr ((number sg))))

                            (let ((temp (member (first fv) fs2 :test '(lambda (a b) (equal a (car b))))))
                                  ;; if member succeeds we would get ((agr ((number sg))))
                              (and temp (optional-matching-fs-p (second fv) (second (cdr temp)))))))
                      t)
                      ((optional-matching-fv-p fv fs2)
                       t)
                      (t (setq res nil) (setq fs nil)))))


#|
;; OK
;; (sv ((cat n) (root foo) (count no)))
;; (sv ((cat n) (root foobar) (count yes)))
;; BAD
;; (sv ((cat n) (root foo) (count no)))
;; (sv ((cat n) (root foobar) (count no)))
(defun compare-lex (lex1 lex2)
     (cond ((and (equal (car lex1) (car lex2))
                 (equal (assoc 'cat (second lex1)) (assoc 'cat (second lex2))))
            (let ((temp1 (remove-if '(lambda (a) (equal (car a) cat)) (second lex1)))
                  (temp2 (remove-if '(lambda (a) (equal (car a) cat)) (second lex2))))
                 (compare-lex-sub temp1 temp2)))
           (t nil)))

;; ignore root and xroot??? 
;; trans count arg???
(defun compare-lex-sub (lex1 lex2)
) ;;;???? how to compare for Wed Oct  9 13:35:07 EDT 2002




|#



