;; Mode: Lisp; Package: User
;;
;;
;; Last Edit 18-Nov-91 by jrrl
;;   1) Made into a public version
;;
;; Edit 31-Mar-90 by EHN
;;    1) File created from v3-3-rt.lisp.
;;
;; Edit: 10-Nov-88 by EHN
;;    1) Added compilation routine.
;;
;; Edit: 08-Nov-88 by EHN
;;    1) File created from v3-2-rt.lisp.
;;    2) Changed name of init file to more mnemonic name.

;; no-load version for DEFSYSTEM - 01-Mar-91 by EHN

;; made back into a load version for CMT public - 18-Nov-91 by jrrl

;; 17-Jul-96 by EHN  -- turned back into no-load version for DEFSYSTEM
;;                   -- eliminated loading of genkit init file (not used?)

(defun banner (&optional (string ""))
  (format *standard-output* "~%;; ~a" string))

(banner "     ******************************************************")
(banner "     **               Generation Kit                     **")
(banner "     **                    and                           **")
(banner "     **             Transformation Kit                   **")
(banner "     **                                                  **")
(banner "     **               RT Version 4-1                     **")
(banner "     **                                                  **")
(banner "     **               Masaru Tomita                      **")
(banner "     **               John Leavitt                       **")
(banner "     **                Eric Nyberg                       **")
(banner "     **                                                  **")
(banner "     **        Center for Machine Translation            **")
(banner "     **          Carnegie Mellon University              **")
(banner "     **         (c) 1996 All rights reserved             **")
(banner "     ******************************************************")
(banner)
(banner "Initializing.....")
(banner)

(pushnew :genkit4.1 *features*)

(defvar *genkit-path*)

(setq *genkit-path* "/afs/cs/project/cmt-49/kant-german/gram/code")

;; Set up file list.

(defvar *genkit-files*)

(setq *genkit-files*
      (mapcar #'(lambda (file)
		  (concatenate 'string *genkit-path* file))
	      '("util" "pseudo-unify" "transfer" "compgen")))

;; 17-Jul-96 by EHN -- JISCODE not needed by any current systems.
;;   '("util" "pseudo-unify" "transfer" "compgen" "jiscode")

;; Load files.

(defun noisy-load (path)
  (format *standard-output* "~%;; Loading ~a." path)
  (force-output *standard-output*)
  (load path))

;; 17-Jul-96 by EHN -- this confuses DEFSYSTEM and makes it hard
;; to workaround corrupted AFS cache binaries.
;;(dolist (file *genkit-files*)
;;  (noisy-load file))

(defun load-genkit ()
  (dolist (file *genkit-files*)
	  (load file)))

;; Look for a file "genkit-init" in the current directory.

;; 17-Jul-96 by EHN -- Not used?
;;(if (or (probe-file "genkit-init.lisp")
;;        (probe-file "genkit-init.fasl"))
;;    (noisy-load "genkit-init"))

;; Compiler routine.

(defun compile-genkit ()
  (dolist (file *genkit-files*)
    (compile-file file)))

(format *standard-output* "~%;;~%;; .....GenKit Version 4-0 Initialized.~%~%")
