/*
 * Decompiled with CFR 0.152.
 */
package com.linearb.util.sentence;

import com.linearb.util.sentence.Phrase;
import java.util.StringTokenizer;

public class WordIDList {
    public static final int HASH_SEED = 17;
    public static final int HASH_OFFSET = 37;
    protected int[] wordIDs;

    public WordIDList(int[] wordIDs) {
        this.wordIDs = wordIDs;
    }

    public WordIDList(Phrase phrase) {
        this.wordIDs = new int[phrase.size()];
        for (int i = 0; i < phrase.size(); ++i) {
            this.wordIDs[i] = phrase.getWord(i).getID();
        }
    }

    public WordIDList(String phraseString) {
        StringTokenizer st = new StringTokenizer(phraseString, " ");
        this.wordIDs = new int[st.countTokens()];
        for (int i = 0; i < this.wordIDs.length; ++i) {
            this.wordIDs[i] = Integer.parseInt(st.nextToken());
        }
    }

    public int get(int i) {
        return this.wordIDs[i];
    }

    public int size() {
        return this.wordIDs.length;
    }

    public int hashCode() {
        int result = 17;
        for (int i = 0; i < this.wordIDs.length; ++i) {
            result = 37 * result + this.wordIDs[i];
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o instanceof WordIDList) {
            WordIDList other = (WordIDList)o;
            if (this.wordIDs.length == other.wordIDs.length) {
                for (int i = 0; i < this.wordIDs.length; ++i) {
                    if (this.wordIDs[i] == other.wordIDs[i]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.wordIDs.length; ++i) {
            buf.append(this.wordIDs[i]);
            if (i >= this.wordIDs.length - 1) continue;
            buf.append(' ');
        }
        return buf.toString();
    }

    public static void main(String[] args) {
    }
}

