/*
 * Decompiled with CFR 0.152.
 */
package com.linearb.util.sentence;

import com.linearb.util.sentence.Phrase;
import com.linearb.util.sentence.Word;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;

public class Vocabulary {
    public static final int UNKNOWN_WORD = -1;
    public static final String UNKNOWN_WORD_STRING = "UNK";
    HashMap wordToIDMap = new HashMap();
    ArrayList vocabList = new ArrayList();
    boolean isFixed;

    public Vocabulary() {
        this.isFixed = false;
    }

    public Vocabulary(Set words) {
        this.vocabList.addAll(words);
        this.alphabetize();
        this.isFixed = true;
    }

    public int getID(Word word) {
        return this.getID(word.getString());
    }

    public int getID(String wordString) {
        Integer ID = (Integer)this.wordToIDMap.get(wordString);
        if (ID == null) {
            return -1;
        }
        return ID;
    }

    public Word getWord(int id) {
        if (id >= this.size() || id == -1) {
            return new Word(UNKNOWN_WORD_STRING, this);
        }
        return (Word)this.vocabList.get(id);
    }

    public Word getWord(String wordString) {
        return this.getWord(this.getID(wordString));
    }

    public int[] getIDs(Phrase phrase) {
        int[] ids = new int[phrase.size()];
        for (int i = 0; i < phrase.size(); ++i) {
            Word word = phrase.getWord(i);
            int id = this.getID(word);
            if (id == -1) {
                return null;
            }
            ids[i] = id;
        }
        return ids;
    }

    public Phrase toPhrase(int[] ids) {
        Phrase phrase = new Phrase(ids.length, this);
        for (int i = 0; i < ids.length; ++i) {
            phrase.add(this.getWord(ids[i]));
        }
        return phrase;
    }

    public int addWord(Word word) {
        String wordString = word.getString();
        Integer ID = (Integer)this.wordToIDMap.get(wordString);
        if (ID != null) {
            return ID;
        }
        if (!this.isFixed) {
            ID = new Integer(this.vocabList.size());
            this.vocabList.add(word);
            this.wordToIDMap.put(wordString, ID);
            return ID;
        }
        return -1;
    }

    public int size() {
        return this.vocabList.size();
    }

    public void fixVocabulary() {
        this.isFixed = true;
    }

    public boolean containsUnkownWords(Phrase phrase) {
        for (int i = 0; i < phrase.size(); ++i) {
            if (this.getID(phrase.getWord(i)) != -1) continue;
            return true;
        }
        return false;
    }

    public void alphabetize() {
        Collections.sort(this.vocabList);
        this.wordToIDMap = new HashMap();
        for (int i = 0; i < this.vocabList.size(); ++i) {
            Word word = (Word)this.vocabList.get(i);
            this.wordToIDMap.put(word.getString(), new Integer(i));
        }
    }

    public String toString() {
        return this.vocabList.toString();
    }

    public static void main(String[] args) throws Exception {
    }
}

