/*
 * Decompiled with CFR 0.152.
 */
package com.linearb.util.sentence;

import com.linearb.util.sentence.Vocabulary;
import com.linearb.util.sentence.Word;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class Phrase
extends ArrayList
implements Comparable {
    public static String SPACE_CHARACTERS = "\u00a0 ";
    private Vocabulary vocab;

    public Phrase(Vocabulary vocab) {
        this.vocab = vocab;
    }

    public Phrase(List list, Vocabulary vocab) {
        super(list);
        this.vocab = vocab;
    }

    public Phrase(int capacity, Vocabulary vocab) {
        super(capacity);
        this.vocab = vocab;
    }

    public Phrase(String phraseString, Vocabulary vocab) {
        this.vocab = vocab;
        StringTokenizer tokenizer = new StringTokenizer(phraseString, SPACE_CHARACTERS);
        while (tokenizer.hasMoreElements()) {
            this.addWord(new Word(tokenizer.nextToken(), vocab));
        }
    }

    public Phrase(Phrase phrase) {
        super(phrase);
        this.vocab = phrase.vocab;
    }

    public void addWord(Word word) {
        this.add(word);
    }

    public void append(Phrase phrase) {
        this.addAll(phrase);
    }

    public Word getWord(int index) {
        return (Word)this.get(index);
    }

    public Vocabulary getVocab() {
        return this.vocab;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.size(); ++i) {
            buf.append(this.get(i));
            if (i >= this.size() - 1) continue;
            buf.append(' ');
        }
        return buf.toString();
    }

    public ArrayList getSubPhrases() {
        return this.getSubPhrases(this.size());
    }

    public ArrayList getSubPhrases(int maxLength) {
        if (maxLength > this.size()) {
            return this.getSubPhrases(this.size());
        }
        ArrayList<Phrase> phrases = new ArrayList<Phrase>();
        for (int i = 0; i < this.size(); ++i) {
            for (int j = i + 1; j <= this.size() && j - i <= maxLength; ++j) {
                Phrase subPhrase = this.subPhrase(i, j);
                phrases.add(subPhrase);
            }
        }
        return phrases;
    }

    public Phrase subPhrase(int start, int end) {
        return new Phrase(this.subList(start, end), this.vocab);
    }

    public int compareTo(Object obj) throws ClassCastException {
        Phrase other = (Phrase)obj;
        for (int i = 0; i < this.size(); ++i) {
            if (i < other.size()) {
                Word otherWord;
                Word thisWord = (Word)this.get(i);
                int wordCompare = thisWord.compareTo(otherWord = (Word)other.get(i));
                if (wordCompare == 0) continue;
                return wordCompare;
            }
            return 1;
        }
        if (this.size() < other.size()) {
            return -1;
        }
        return 0;
    }

    public int[] getWordIDArray() {
        int[] wordIDs = new int[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            wordIDs[i] = this.getWord(i).getID();
        }
        return wordIDs;
    }

    public static void main(String[] args) {
        Vocabulary vocab = new Vocabulary();
        Phrase a = new Phrase("hello world .", vocab);
        Phrase b = new Phrase("hello world .", vocab);
        Word c = new Word("hello", vocab);
        Word d = new Word("hello", vocab);
        System.out.println(c.equals(d));
        System.out.println(a);
        System.out.println(b);
        System.out.println(a.equals(b));
    }
}

