/*
 * Decompiled with CFR 0.152.
 */
package com.linearb.util.sentence;

import com.linearb.util.sentence.Coordinate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;

public class Grid {
    public static final int MAX_LENGTH = 100;
    private static final short X_SHIFT = 100;
    protected int width;
    protected int height;
    protected short[] coordinates;
    protected short[] transposedCoordinates;
    protected boolean transposed = false;

    public Grid(int width, int height, Collection coordinates) {
        this.width = width;
        this.height = height;
        this.initializeCoordinates(coordinates);
    }

    public Grid(boolean[][] array) {
        this.width = array.length;
        this.height = array[0].length;
        this.initializeCoordinates(array);
    }

    public Grid(int width, int height) {
        this.width = width;
        this.height = height;
        this.initializeCoordinates(new HashSet());
    }

    public Grid(String alignmentPoints) {
        HashSet<Coordinate> coordinates = new HashSet<Coordinate>();
        StringTokenizer st = new StringTokenizer(alignmentPoints, ",");
        while (st.hasMoreTokens()) {
            Coordinate coord = Coordinate.toCoordinate(st.nextToken());
            this.width = Math.max(this.width, coord.x + 1);
            this.height = Math.max(this.height, coord.y + 1);
            coordinates.add(coord);
        }
        this.initializeCoordinates(coordinates);
    }

    public Grid(int width, int height, String alignmentPoints) {
        this.width = width;
        this.height = height;
        HashSet<Coordinate> coordinates = new HashSet<Coordinate>();
        StringTokenizer st = new StringTokenizer(alignmentPoints, ",");
        while (st.hasMoreTokens()) {
            Coordinate coord = Coordinate.toCoordinate(st.nextToken());
            coordinates.add(coord);
        }
        this.initializeCoordinates(coordinates);
    }

    public int cardinality() {
        return this.coordinates.length;
    }

    public int getWidth() {
        if (this.transposed) {
            return this.height;
        }
        return this.width;
    }

    public int getHeight() {
        if (this.transposed) {
            return this.width;
        }
        return this.height;
    }

    public boolean isTransposed() {
        return this.transposed;
    }

    public boolean isValid(int x, int y) {
        return x >= 0 && y >= 0 && x < this.getWidth() && y < this.getHeight();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!o.getClass().isInstance(this)) {
            return false;
        }
        Grid other = (Grid)o;
        return this.getWidth() == other.getWidth() && this.getHeight() == other.getHeight() && Arrays.equals(this.getCoordinates(), other.getCoordinates());
    }

    public boolean contains(Coordinate location) {
        return this.contains(location.x, location.y);
    }

    public boolean contains(int x, int y) {
        if (this.isValid(x, y)) {
            int index = Arrays.binarySearch(this.getCoordinates(), this.getKey(x, y));
            return index >= 0;
        }
        throw new ArrayIndexOutOfBoundsException("(" + x + "," + y + ")");
    }

    public boolean[][] generateBooleanArray() {
        int width = this.getWidth();
        int height = this.getHeight();
        boolean[][] array = new boolean[width][height];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                array[x][y] = false;
            }
        }
        for (int i = 0; i < this.getCoordinates().length; ++i) {
            short[] location = this.getLocation(this.getCoordinates()[i]);
            if (location == null) continue;
            array[location[0]][location[1]] = true;
        }
        return array;
    }

    public Collection generateCoordinates() {
        HashSet<Coordinate> coordinates = new HashSet<Coordinate>();
        short[] points = this.getCoordinates();
        for (int i = 0; i < points.length; ++i) {
            short[] coordTuple = this.getLocation(points[i]);
            Coordinate coord = new Coordinate(coordTuple[0], coordTuple[1]);
            coordinates.add(coord);
        }
        return coordinates;
    }

    public void transpose() {
        this.transposed = !this.transposed;
    }

    public int[] getRowPoints(int columnStart, int columnEnd) {
        return this.getPoints(columnStart, columnEnd, this.getHeight(), this.getCoordinates());
    }

    public int[] getColumnPoints(int rowStart, int rowEnd) {
        return this.getPoints(rowStart, rowEnd, this.getWidth(), this.getTransposedCoordinates());
    }

    public int[] getPoints(int start, int end, int maxKey, short[] points) {
        short startKey = this.getKey(start, 0);
        short endKey = this.getKey(end - 1, maxKey);
        int startIndex = Arrays.binarySearch(points, startKey);
        int endIndex = Arrays.binarySearch(points, endKey);
        if (startIndex < 0) {
            startIndex = (startIndex + 1) * -1;
        }
        if (endIndex < 0) {
            endIndex = (endIndex + 1) * -1;
        }
        int[] result = new int[endIndex - startIndex];
        for (int i = startIndex; i < endIndex; ++i) {
            result[i - startIndex] = points[i] % 100;
        }
        Arrays.sort(result);
        return result;
    }

    protected void initializeCoordinates(Collection coordinates) {
        Iterator it = coordinates.iterator();
        this.coordinates = new short[coordinates.size()];
        this.transposedCoordinates = new short[coordinates.size()];
        int index = 0;
        while (it.hasNext()) {
            Coordinate coordinate = (Coordinate)it.next();
            this.coordinates[index] = this.getKey(coordinate.x, coordinate.y);
            this.transposedCoordinates[index] = this.getKey(coordinate.y, coordinate.x);
            ++index;
        }
        Arrays.sort(this.coordinates);
        Arrays.sort(this.transposedCoordinates);
    }

    protected void initializeCoordinates(boolean[][] array) {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                if (!array[x][y]) continue;
                Coordinate coordinate = new Coordinate(x, y);
                coordinates.add(coordinate);
            }
        }
        this.initializeCoordinates(coordinates);
    }

    protected short getKey(int x, int y) {
        int key = x * 100 + y;
        return (short)key;
    }

    protected short[] getLocation(short key) {
        short[] location = new short[]{(short)(key / 100), (short)(key % 100)};
        return location;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.getCoordinates().length; ++i) {
            short[] location = this.getLocation(this.getCoordinates()[i]);
            if (location == null) continue;
            buf.append(location[0]);
            buf.append('.');
            buf.append(location[1]);
            buf.append(',');
        }
        if (buf.length() > 0) {
            buf.deleteCharAt(buf.length() - 1);
        }
        return buf.toString();
    }

    public String toAsciiGraph() {
        StringBuffer buffer = new StringBuffer();
        boolean[][] array = this.generateBooleanArray();
        if (array.length == 0) {
            return "";
        }
        for (int y = 0; y < array[0].length; ++y) {
            buffer.append("|");
            for (int x = 0; x < array.length; ++x) {
                if (array[x][y]) {
                    buffer.append("XX");
                } else {
                    buffer.append("  ");
                }
                buffer.append("|");
            }
            buffer.append("\n");
        }
        return buffer.toString();
    }

    protected short[] getCoordinates() {
        if (this.transposed) {
            return this.transposedCoordinates;
        }
        return this.coordinates;
    }

    protected short[] getTransposedCoordinates() {
        if (this.transposed) {
            return this.coordinates;
        }
        return this.transposedCoordinates;
    }

    public static Grid extend(Grid grid1, Grid grid2) {
        int width = grid1.getWidth() + grid2.getWidth();
        int height = grid1.getHeight() + grid2.getHeight();
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        short[] points = grid1.getCoordinates();
        for (int i = 0; i < points.length; ++i) {
            short[] coord = grid1.getLocation(points[i]);
            if (coord == null) continue;
            coordinates.add(new Coordinate(coord[0], coord[1]));
        }
        int xOffset = grid1.getWidth();
        int yOffset = grid1.getHeight();
        points = grid2.getCoordinates();
        for (int i = 0; i < points.length; ++i) {
            short[] coord = grid2.getLocation(points[i]);
            if (coord == null) continue;
            coordinates.add(new Coordinate(coord[0] + xOffset, coord[1] + yOffset));
        }
        return new Grid(width, height, coordinates);
    }

    protected static Grid extend(int width, int height, Grid grid1, int xOffset1, int yOffset1, Grid grid2, int xOffset2, int yOffset2) {
        short[] coord;
        int i;
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        short[] points = grid1.getCoordinates();
        for (i = 0; i < points.length; ++i) {
            coord = grid1.getLocation(points[i]);
            if (coord == null) continue;
            coordinates.add(new Coordinate(coord[0] + xOffset1, coord[1] + yOffset1));
        }
        points = grid2.getCoordinates();
        for (i = 0; i < points.length; ++i) {
            coord = grid2.getLocation(points[i]);
            if (coord == null) continue;
            coordinates.add(new Coordinate(coord[0] + xOffset2, coord[1] + yOffset2));
        }
        return new Grid(width, height, coordinates);
    }

    public static Grid intersection(Grid grid1, Grid grid2) {
        boolean[][] array1 = grid1.generateBooleanArray();
        boolean[][] array2 = grid2.generateBooleanArray();
        int width = grid1.getWidth();
        int height = grid1.getHeight();
        boolean[][] intersection = new boolean[width][height];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                intersection[x][y] = array1[x][y] && array2[x][y];
            }
        }
        return new Grid(intersection);
    }

    public static Grid union(Grid grid1, Grid grid2) {
        boolean[][] array1 = grid1.generateBooleanArray();
        boolean[][] array2 = grid2.generateBooleanArray();
        int width = grid1.getWidth();
        int height = grid1.getHeight();
        boolean[][] union = new boolean[width][height];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                union[x][y] = array1[x][y] || array2[x][y];
            }
        }
        return new Grid(union);
    }

    public static Grid delta(Grid grid1, Grid grid2) {
        boolean[][] union = Grid.union(grid1, grid2).generateBooleanArray();
        boolean[][] intersection = Grid.intersection(grid1, grid2).generateBooleanArray();
        int width = grid1.getWidth();
        int height = grid1.getHeight();
        boolean[][] difference = new boolean[width][height];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                difference[x][y] = union[x][y] && !intersection[x][y];
            }
        }
        return new Grid(difference);
    }

    public static boolean rowEmpty(int y, boolean[][] array) {
        boolean empty = true;
        for (int x = 0; x < array.length; ++x) {
            boolean bl = empty = empty && !array[x][y];
            if (empty) continue;
            return false;
        }
        return true;
    }

    public static boolean columnEmpty(int x, boolean[][] array) {
        boolean empty = true;
        for (int y = 0; y < array[x].length; ++y) {
            boolean bl = empty = empty && !array[x][y];
            if (empty) continue;
            return false;
        }
        return true;
    }

    public static boolean generatesBothNeighbors(int x, int y, boolean[][] points) {
        if (Grid.hasBothNeighbors(x, y, points)) {
            return true;
        }
        for (int i = x - 1; i <= x + 1; ++i) {
            for (int j = y - 1; j < y + 1; ++j) {
                if (!Grid.inBounds(i, j, points) || !Grid.hasBothNeighbors(i, j, points)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasNeighbor(int x, int y, boolean[][] array) {
        return Grid.hasVerticalNeighbor(x, y, array) || Grid.hasHorizontalNeighbor(x, y, array) || Grid.hasDiagonalNeighbor(x, y, array);
    }

    public static boolean hasBothNeighbors(int x, int y, boolean[][] array) {
        return Grid.hasVerticalNeighbor(x, y, array) && Grid.hasHorizontalNeighbor(x, y, array);
    }

    public static boolean hasVerticalNeighbor(int x, int y, boolean[][] array) {
        return Grid.hasAboveNeighbor(x, y, array) || Grid.hasBelowNeighbor(x, y, array);
    }

    public static boolean hasHorizontalNeighbor(int x, int y, boolean[][] array) {
        return Grid.hasLeftNeighbor(x, y, array) || Grid.hasRightNeighbor(x, y, array);
    }

    public static boolean hasDiagonalNeighbor(int x, int y, boolean[][] array) {
        for (int i = x - 1; i <= x + 1; ++i) {
            for (int j = y - 1; j <= y + 1; ++j) {
                if (i == x || j == y || !Grid.inBounds(i, j, array) || !array[i][j]) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean inBounds(int x, int y, boolean[][] array) {
        return x >= 0 && y >= 0 && x < array.length && y < array[x].length;
    }

    public static boolean hasRightNeighbor(int x, int y, boolean[][] array) {
        if (x + 1 < array.length) {
            return array[x + 1][y];
        }
        return false;
    }

    public static boolean hasLeftNeighbor(int x, int y, boolean[][] array) {
        if (x - 1 >= 0) {
            return array[x - 1][y];
        }
        return false;
    }

    public static boolean hasAboveNeighbor(int x, int y, boolean[][] array) {
        if (y - 1 >= 0) {
            return array[x][y - 1];
        }
        return false;
    }

    public static boolean hasBelowNeighbor(int x, int y, boolean[][] array) {
        if (y + 1 < array[x].length) {
            return array[x][y + 1];
        }
        return false;
    }

    public static boolean hasBelowRightNeighbor(int x, int y, boolean[][] array) {
        if (x + 1 < array.length && y + 1 < array[x + 1].length) {
            return array[x + 1][y + 1];
        }
        return false;
    }

    public static boolean isRectangleUpperLeft(int x, int y, boolean[][] array) {
        return Grid.hasRightNeighbor(x, y, array) && Grid.hasBelowNeighbor(x, y, array) && Grid.hasBelowRightNeighbor(x, y, array);
    }

    public static void main(String[] args) {
        ArrayList<Coordinate> coords = new ArrayList<Coordinate>();
        coords.add(new Coordinate(0, 0));
        coords.add(new Coordinate(1, 1));
        coords.add(new Coordinate(2, 1));
        Grid grid = new Grid(3, 3, coords);
        ArrayList<Coordinate> coords2 = new ArrayList<Coordinate>();
        coords2.add(new Coordinate(2, 0));
        coords2.add(new Coordinate(1, 1));
        coords2.add(new Coordinate(0, 2));
        Grid grid2 = new Grid(3, 3, coords2);
        System.out.println(grid.toAsciiGraph());
        System.out.println(grid2.toAsciiGraph());
        System.out.println(Grid.extend(grid, grid2).toAsciiGraph());
    }
}

