/*
 * Decompiled with CFR 0.152.
 */
package com.linearb.util.sentence;

import com.linearb.eval.ProbableAlignment;
import com.linearb.util.FileUtil;
import com.linearb.util.sentence.Alignment;
import com.linearb.util.sentence.Coordinate;
import com.linearb.util.sentence.Grid;
import com.linearb.util.sentence.Phrase;
import com.linearb.util.sentence.Vocabulary;
import com.linearb.util.sentence.Word;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;

public class AlignmentUtil {
    public static final String GOLD_STANDARD_SENTENCE_START = "<s snum=";
    public static final String GOLD_STANDARD_SENTENCE_END = " </s";
    public static final char END_TAG = '>';

    public static ArrayList loadGizaAlignments(String filename) throws IOException {
        return AlignmentUtil.loadGizaAlignments(filename, new Vocabulary(), new Vocabulary());
    }

    public static ArrayList loadGizaAlignments(String filename, Vocabulary sourceVocab, Vocabulary targetVocab) throws IOException {
        ArrayList<Alignment> alignments = new ArrayList<Alignment>();
        BufferedReader reader = FileUtil.getBufferedReader(filename);
        while (reader.ready()) {
            String metaInfo = reader.readLine();
            String targetLine = reader.readLine();
            String sourceLine = reader.readLine();
            alignments.add(AlignmentUtil.parseGizaAlignment(metaInfo, targetLine, sourceLine, sourceVocab, targetVocab));
        }
        reader.close();
        return alignments;
    }

    public static ArrayList loadAlignments(String filename) throws IOException {
        return AlignmentUtil.loadAlignments(filename, new Vocabulary(), new Vocabulary());
    }

    public static ArrayList loadAlignments(String filename, Vocabulary sourceVocab, Vocabulary targetVocab) throws IOException {
        ArrayList<Alignment> alignments = new ArrayList<Alignment>();
        BufferedReader reader = FileUtil.getBufferedReader(filename);
        while (reader.ready()) {
            String source = reader.readLine();
            String target = reader.readLine();
            String alignmentPoints = reader.readLine();
            alignments.add(new Alignment(new Phrase(source, sourceVocab), new Phrase(target, targetVocab), new Grid(alignmentPoints)));
        }
        reader.close();
        return alignments;
    }

    public static ArrayList loadGoldStandardAlignments(String sourceFilename, String targetFilename, String wordAlignmentsFilename) throws IOException {
        return AlignmentUtil.loadGoldStandardAlignments(sourceFilename, targetFilename, wordAlignmentsFilename, new Vocabulary(), new Vocabulary());
    }

    public static ArrayList loadGoldStandardAlignments(String sourceFilename, String targetFilename, String wordAlignmentsFilename, Vocabulary sourceVocab, Vocabulary targetVocab) throws IOException {
        ArrayList<ProbableAlignment> alignments = new ArrayList<ProbableAlignment>();
        BufferedReader sourceReader = FileUtil.getBufferedReader(sourceFilename);
        BufferedReader targetReader = FileUtil.getBufferedReader(targetFilename);
        BufferedReader alignmentReader = FileUtil.getBufferedReader(wordAlignmentsFilename);
        HashMap[] sureAndProbableAlignments = AlignmentUtil.parseGoldStandardAlignmentPoints(alignmentReader);
        alignmentReader.close();
        while (sourceReader.ready()) {
            String sourceString = sourceReader.readLine();
            String targetString = targetReader.readLine();
            Integer sentenceNumber = AlignmentUtil.getGoldStandardSentenceNum(sourceString);
            if (!sentenceNumber.equals(AlignmentUtil.getGoldStandardSentenceNum(targetString))) {
                IOException ioe = new IOException("Source and target files are not in the same order.");
                throw ioe;
            }
            Phrase source = AlignmentUtil.parseGoldStandardSentenceLine(sourceString, sourceVocab);
            Phrase target = AlignmentUtil.parseGoldStandardSentenceLine(targetString, targetVocab);
            HashSet sureAlignmentPoints = (HashSet)sureAndProbableAlignments[0].get(sentenceNumber);
            HashSet probableAlignmentPoints = (HashSet)sureAndProbableAlignments[1].get(sentenceNumber);
            if (probableAlignmentPoints == null) {
                probableAlignmentPoints = new HashSet();
            }
            if (sureAlignmentPoints == null) {
                sureAlignmentPoints = new HashSet();
            }
            ProbableAlignment alignment = new ProbableAlignment(source, target, new Grid(source.size(), target.size(), sureAlignmentPoints), new Grid(source.size(), target.size(), probableAlignmentPoints));
            alignment.setID(sentenceNumber);
            alignments.add(alignment);
        }
        sourceReader.close();
        targetReader.close();
        return alignments;
    }

    public static void writeGoldStandardSentences(ArrayList alignments, String sourceFile, String targetFile, String alignmentsFile) throws IOException {
        AlignmentUtil.writeGoldStandardAlignmentPoints(alignments, alignmentsFile);
        BufferedWriter sourceWriter = FileUtil.getBufferedWriter(sourceFile, false);
        BufferedWriter targetWriter = FileUtil.getBufferedWriter(targetFile, false);
        for (int i = 0; i < alignments.size(); ++i) {
            ProbableAlignment alignment = (ProbableAlignment)alignments.get(i);
            int ID = alignment.getID();
            if (ID == -1) {
                ID = i + 1;
            }
            String source = alignment.getSource().toString();
            source = GOLD_STANDARD_SENTENCE_START + Integer.toString(ID) + "> " + source + " </s>";
            sourceWriter.write(source, 0, source.length());
            sourceWriter.newLine();
            String target = alignment.getTarget().toString();
            target = GOLD_STANDARD_SENTENCE_START + Integer.toString(ID) + "> " + target + " </s>";
            targetWriter.write(target, 0, target.length());
            targetWriter.newLine();
            sourceWriter.flush();
            targetWriter.flush();
        }
        sourceWriter.close();
        targetWriter.close();
    }

    public static void writeGoldStandardAlignmentPoints(ArrayList alignments, String filename) throws IOException {
        BufferedWriter writer = FileUtil.getBufferedWriter(filename, false);
        for (int i = 0; i < alignments.size(); ++i) {
            String line;
            Coordinate coord;
            ProbableAlignment alignment = (ProbableAlignment)alignments.get(i);
            int ID = alignment.getID();
            if (ID == -1) {
                ID = i + 1;
            }
            Collection coordinates = alignment.getSureAlignmentPoints().generateCoordinates();
            Iterator it = coordinates.iterator();
            while (it.hasNext()) {
                coord = (Coordinate)it.next();
                line = Integer.toString(ID) + " ";
                line = line + Integer.toString(coord.x + 1) + " " + Integer.toString(coord.y + 1) + " S";
                writer.write(line, 0, line.length());
                writer.newLine();
                writer.flush();
            }
            coordinates = alignment.getProbableAlignmentPoints().generateCoordinates();
            it = coordinates.iterator();
            while (it.hasNext()) {
                coord = (Coordinate)it.next();
                if (alignment.containsSureAt(coord.x, coord.y)) continue;
                line = Integer.toString(ID) + " ";
                line = line + Integer.toString(coord.x + 1) + " " + Integer.toString(coord.y + 1) + " P";
                writer.write(line, 0, line.length());
                writer.newLine();
                writer.flush();
            }
        }
        writer.close();
    }

    public static ArrayList makeBialign(String gizaFile1, String gizaFile2) throws IOException {
        ArrayList alignments = AlignmentUtil.loadGizaAlignments(gizaFile1);
        ArrayList alignments2 = AlignmentUtil.loadGizaAlignments(gizaFile2);
        for (int i = 0; i < alignments.size(); ++i) {
            Alignment alignment1 = (Alignment)alignments.get(i);
            Alignment alignment2 = (Alignment)alignments.get(i);
            alignment1.transpose();
            if (alignment1.getSourceLength() == alignment2.getSourceLength() && alignment1.getTargetLength() == alignment2.getTargetLength()) {
                Grid heruristicAlignment = AlignmentUtil.heuristicMerge(alignment1.getAlignmentPoints(), alignment2.getAlignmentPoints());
                alignment1.setAlignmentPoints(heruristicAlignment);
                continue;
            }
            System.err.println("Warning: Alignment number " + (i + 1) + " has mismatched lenghts");
        }
        return alignments;
    }

    public static ArrayList toProbableAlignments(ArrayList alignments) {
        ArrayList<ProbableAlignment> probableAlignments = new ArrayList<ProbableAlignment>(alignments.size());
        Iterator it = alignments.iterator();
        while (it.hasNext()) {
            Alignment alignment = (Alignment)it.next();
            probableAlignments.add(new ProbableAlignment(alignment));
        }
        return probableAlignments;
    }

    private static HashMap[] parseGoldStandardAlignmentPoints(BufferedReader alignmentReader) throws IOException {
        HashMap<Integer, HashSet<Coordinate>> sureAlignments = new HashMap<Integer, HashSet<Coordinate>>();
        HashMap<Integer, HashSet<Coordinate>> probableAlignments = new HashMap<Integer, HashSet<Coordinate>>();
        while (alignmentReader.ready()) {
            HashSet<Coordinate> coordinates;
            String alignmentLine = alignmentReader.readLine();
            StringTokenizer tokenizer = new StringTokenizer(alignmentLine, " ");
            Integer sentenceNum = new Integer(tokenizer.nextToken());
            int sourceWord = Integer.parseInt(tokenizer.nextToken()) - 1;
            int targetWord = Integer.parseInt(tokenizer.nextToken()) - 1;
            String sureProb = "S";
            if (tokenizer.hasMoreTokens()) {
                sureProb = tokenizer.nextToken();
            }
            if (sureProb.equals("S")) {
                coordinates = (HashSet<Coordinate>)sureAlignments.get(sentenceNum);
                if (coordinates == null) {
                    coordinates = new HashSet<Coordinate>();
                }
                coordinates.add(new Coordinate(sourceWord, targetWord));
                sureAlignments.put(sentenceNum, coordinates);
            }
            if ((coordinates = (Collection)probableAlignments.get(sentenceNum)) == null) {
                coordinates = new HashSet();
            }
            coordinates.add(new Coordinate(sourceWord, targetWord));
            probableAlignments.put(sentenceNum, coordinates);
        }
        HashMap[] results = new HashMap[]{sureAlignments, probableAlignments};
        return results;
    }

    private static Integer getGoldStandardSentenceNum(String sentenceLine) {
        String sentenceNumString = sentenceLine.substring(GOLD_STANDARD_SENTENCE_START.length(), sentenceLine.indexOf(62));
        return new Integer(sentenceNumString);
    }

    private static Phrase parseGoldStandardSentenceLine(String sentenceLine, Vocabulary vocab) {
        String sentenceString = sentenceLine.substring(sentenceLine.indexOf(62) + 1, sentenceLine.indexOf(GOLD_STANDARD_SENTENCE_END));
        sentenceString = sentenceString.trim();
        return new Phrase(sentenceString, vocab);
    }

    private static Alignment parseGizaAlignment(String metaInfo, String targetLine, String sourceLine, Vocabulary sourceVocab, Vocabulary targetVocab) {
        Phrase source = new Phrase(sourceVocab);
        Phrase target = new Phrase(targetLine, targetVocab);
        int targetLength = target.size();
        Word NULL = new Word("NULL", sourceVocab);
        StringTokenizer tokenizer = new StringTokenizer(sourceLine, " ");
        HashSet<Coordinate> coordinates = new HashSet<Coordinate>();
        while (tokenizer.hasMoreElements()) {
            Word sourceWord = new Word((String)tokenizer.nextElement(), sourceVocab);
            if (!sourceWord.equals(NULL)) {
                source.add(sourceWord);
            }
            tokenizer.nextElement();
            String token = (String)tokenizer.nextElement();
            while (!token.equals("})")) {
                int targetIndex = Integer.parseInt(token);
                int x = source.size() - 1;
                int y = targetIndex - 1;
                if (x > -1) {
                    Coordinate coord = new Coordinate(x, y);
                    coordinates.add(coord);
                }
                token = (String)tokenizer.nextElement();
            }
        }
        Grid grid = new Grid(source.size(), target.size(), coordinates);
        return new Alignment(source, target, grid);
    }

    private static Grid heuristicMerge(Grid grid1, Grid grid2) {
        Grid deltaGrid = Grid.delta(grid1, grid2);
        Grid intersectionGrid = Grid.intersection(grid1, grid2);
        boolean[][] points = intersectionGrid.generateBooleanArray();
        boolean[][] delta = deltaGrid.generateBooleanArray();
        for (int x = 0; x < points.length; ++x) {
            for (int y = 0; y < points[x].length; ++y) {
                if (!delta[x][y]) continue;
                if (Grid.columnEmpty(x, points) && Grid.rowEmpty(y, points)) {
                    points[x][y] = true;
                    continue;
                }
                if (!Grid.hasNeighbor(x, y, points)) continue;
                points[x][y] = true;
                if (!Grid.generatesBothNeighbors(x, y, points)) continue;
                points[x][y] = false;
            }
        }
        return new Grid(points);
    }

    public static void main(String[] args) throws Exception {
        String method = args[0];
        if (method.equals("-giza2goldstandard")) {
            if (args.length == 5) {
                String gizaFile = args[1];
                String sourceSentenceFile = args[2];
                String targetSentenceFile = args[3];
                String alignmentFile = args[4];
                ArrayList alignments = AlignmentUtil.loadGizaAlignments(gizaFile);
                AlignmentUtil.writeGoldStandardSentences(AlignmentUtil.toProbableAlignments(alignments), sourceSentenceFile, targetSentenceFile, alignmentFile);
            } else if (args.length == 6) {
                String gizaFile1 = args[1];
                String gizaFile2 = args[2];
                String sourceSentenceFile = args[3];
                String targetSentenceFile = args[4];
                String alignmentFile = args[5];
                ArrayList alignments = AlignmentUtil.makeBialign(gizaFile1, gizaFile2);
                AlignmentUtil.writeGoldStandardSentences(AlignmentUtil.toProbableAlignments(alignments), sourceSentenceFile, targetSentenceFile, alignmentFile);
            } else {
                System.out.println("Usage: java AlignmentUtil -giza2goldstandard gizaFile (gizaFile2) sourceSentenceFile targetSentenceFile alignmentsFile");
                System.out.println("If two Giza files are specified then the method will perform a heuristic alignment between them.");
                System.exit(0);
            }
        } else {
            System.out.println("Usage: java AlignmentUtil -giza2goldstandard");
        }
    }
}

