/*
 * Decompiled with CFR 0.152.
 */
package com.linearb.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.zip.GZIPInputStream;

public class FileUtil {
    public static boolean exists(String directory, String filename) {
        File file = new File(directory, filename);
        return file.exists();
    }

    public static boolean exists(String filename) {
        File file = new File(filename);
        return file.exists();
    }

    public static BufferedReader getBufferedReader(String directory, String filename) throws IOException {
        InputStream stream = new FileInputStream(new File(directory, filename));
        if (filename.endsWith(".gz")) {
            stream = new GZIPInputStream(stream);
        }
        return new BufferedReader(new InputStreamReader(stream, "utf8"));
    }

    public static BufferedReader getBufferedReader(String filename) throws IOException {
        InputStream stream = new FileInputStream(new File(filename));
        if (filename.endsWith(".gz")) {
            stream = new GZIPInputStream(stream);
        }
        return new BufferedReader(new InputStreamReader(stream));
    }

    public static BufferedWriter getBufferedWriter(String directory, String filename) throws IOException {
        return FileUtil.getBufferedWriter(directory, filename, false);
    }

    public static BufferedWriter getBufferedWriter(String directory, String filename, boolean append) throws IOException {
        File file = new File(directory, filename);
        return new BufferedWriter(new FileWriter(file, append));
    }

    public static BufferedWriter getBufferedWriter(String filename, boolean append) throws IOException {
        File file = new File(filename);
        return new BufferedWriter(new FileWriter(file, append));
    }

    public static void appendToFile(String str, String filename, boolean appendNewLine) throws IOException {
        BufferedWriter writer = FileUtil.getBufferedWriter(filename, true);
        writer.write(str, 0, str.length());
        if (appendNewLine) {
            writer.newLine();
        }
        writer.close();
    }

    public static PrintStream getPrintStream(String filename) throws IOException {
        boolean autoFlush = true;
        return new PrintStream(new FileOutputStream(filename), autoFlush);
    }

    public static void main(String[] args) {
    }
}

