/*
 * Decompiled with CFR 0.152.
 */
package com.linearb.eval.annotation;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class ThreeStateButton
extends JButton {
    private static ImageIcon BLACK;
    private static ImageIcon WHITE;
    private static ImageIcon GRAY;
    private static ImageIcon PINK;
    public static final String NONE = "NONE";
    public static final String SURE = "SURE";
    public static final String PROB = "PROB";
    public boolean isHighlighted;

    public ThreeStateButton(String state) {
        this(state, false);
    }

    public ThreeStateButton(String state, boolean isHighlighted) {
        this.setActionCommand(state);
        this.isHighlighted = isHighlighted;
        if (state.equals(SURE)) {
            this.setIcon(BLACK);
        } else if (state.equals(PROB)) {
            this.setIcon(GRAY);
        } else if (isHighlighted) {
            this.setIcon(PINK);
        } else {
            this.setIcon(WHITE);
        }
        this.addMouseListener(new ThreeStateButtonMouseListener(this));
    }

    protected ThreeStateButton() {
    }

    public String getValue() {
        return this.getActionCommand();
    }

    private static ImageIcon createImageIcon(String path) throws MalformedURLException, IOException {
        ThreeStateButton.testURLConnection(path);
        return new ImageIcon(new URL(path));
    }

    private static void testURLConnection(String path) throws IOException {
        URL testURL = new URL(path);
        BufferedReader in = new BufferedReader(new InputStreamReader(testURL.openStream()));
        in.close();
    }

    public static void main(String[] args) {
    }

    static {
        try {
            ThreeStateButton button = new ThreeStateButton();
            BLACK = new ImageIcon(button.getClass().getResource("images/black.gif"));
            WHITE = new ImageIcon(button.getClass().getResource("images/white.gif"));
            GRAY = new ImageIcon(button.getClass().getResource("images/gray.gif"));
            PINK = new ImageIcon(button.getClass().getResource("images/pink.gif"));
        }
        catch (Exception e) {
            try {
                BLACK = ThreeStateButton.createImageIcon("http://linearb.co.uk/media/images/black.gif");
                WHITE = ThreeStateButton.createImageIcon("http://linearb.co.uk/media/images/white.gif");
                GRAY = ThreeStateButton.createImageIcon("http://linearb.co.uk/media/images/gray.gif");
                PINK = ThreeStateButton.createImageIcon("http://linearb.co.uk/media/images/pink.gif");
            }
            catch (Exception e2) {
                System.err.println("Couldn't access the button images.");
                System.err.println(e);
                System.err.println(e2);
                System.exit(0);
            }
        }
    }

    class ThreeStateButtonMouseListener
    implements MouseListener {
        private ThreeStateButton mButton;

        ThreeStateButtonMouseListener(ThreeStateButton button) {
            this.mButton = button;
        }

        public void mouseClicked(MouseEvent e) {
            String state = this.mButton.getValue();
            this.setState(state);
        }

        public void setState(String state) {
            if (state.equals(ThreeStateButton.NONE)) {
                this.mButton.setIcon(BLACK);
                this.mButton.setActionCommand(ThreeStateButton.SURE);
            } else if (state.equals(ThreeStateButton.SURE)) {
                this.mButton.setIcon(GRAY);
                this.mButton.setActionCommand(ThreeStateButton.PROB);
            } else {
                if (ThreeStateButton.this.isHighlighted) {
                    this.mButton.setIcon(PINK);
                } else {
                    this.mButton.setIcon(WHITE);
                }
                this.mButton.setActionCommand(ThreeStateButton.NONE);
            }
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }
    }
}

