/*
 * Decompiled with CFR 0.152.
 */
package com.linearb.eval.annotation;

import com.linearb.eval.ProbableAlignment;
import com.linearb.eval.annotation.AlignmentJTable;
import com.linearb.eval.annotation.AnnotationDataModel;
import com.linearb.util.sentence.AlignmentUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class AnnotationTool {
    protected static double FONT_SCALE = 1.0;
    private JFrame GUI;
    private AlignmentJTable alignmentTable;
    private JFrame navigationWindow;
    private JButton nextButton;
    private JButton backButton;
    private JButton goToButton;
    private JLabel numAlignmentsLabel;
    private JButton saveButton;
    private JTextField goToField;
    private ArrayList alignments;
    private int currAlignment = 0;
    protected String alignmentFilename;

    public AnnotationTool(ArrayList alignments, String alignmentFilename) {
        this.alignments = alignments;
        this.alignmentFilename = alignmentFilename;
        this.createComponents();
        this.setActions();
        this.GUI.setContentPane(this.layoutContents());
        this.GUI.pack();
        this.GUI.setVisible(true);
        this.navigationWindow.setVisible(true);
    }

    public void setAlignments(ArrayList alignments) {
        this.currAlignment = 0;
        this.alignments = alignments;
        this.numAlignmentsLabel.setText(" of " + Integer.toString(alignments.size()));
        this.updateWindows();
    }

    private void createComponents() {
        this.GUI = new JFrame("Alignment Tool");
        ProbableAlignment alignment = this.getCurrentAlignment();
        this.alignmentTable = new AlignmentJTable(new AnnotationDataModel(alignment));
        this.alignmentTable.setAutoResizeMode(0);
        this.alignmentTable.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent me) {
                int row = AnnotationTool.this.alignmentTable.rowAtPoint(me.getPoint());
                int col = AnnotationTool.this.alignmentTable.columnAtPoint(me.getPoint());
                String toolTip = row < 0 || col < 1 ? null : AnnotationTool.this.alignmentTable.getWordPair(row, col);
                AnnotationTool.this.alignmentTable.setToolTipText(toolTip);
            }
        });
        this.navigationWindow = new JFrame("Navigation");
        this.nextButton = new JButton("Next -->");
        this.backButton = new JButton("<-- Back");
        this.backButton.setEnabled(this.currAlignment > 0);
        this.saveButton = new JButton("Save");
        this.goToField = new JTextField("1     ");
        this.goToButton = new JButton("Go to");
        this.numAlignmentsLabel = new JLabel(" of " + Integer.toString(this.alignments.size()));
    }

    private void setActions() {
        this.GUI.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                AnnotationTool.this.saveChanges();
                System.exit(0);
            }
        });
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AnnotationTool.this.saveChanges();
            }
        });
        this.backButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AnnotationTool.this.currAlignment--;
                AnnotationTool.this.updateWindows();
            }
        });
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AnnotationTool.this.currAlignment++;
                AnnotationTool.this.updateWindows();
            }
        });
        this.goToButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    int goToNum = Integer.parseInt(AnnotationTool.this.goToField.getText().trim());
                    if (goToNum > 0 && goToNum <= AnnotationTool.this.alignments.size()) {
                        AnnotationTool.this.currAlignment = goToNum - 1;
                        AnnotationTool.this.updateWindows();
                    } else {
                        AnnotationTool.this.goToField.setText(Integer.toString(AnnotationTool.this.alignments.size()));
                    }
                }
                catch (NumberFormatException nfe) {
                    AnnotationTool.this.goToField.setText(Integer.toString(AnnotationTool.this.alignments.size()));
                }
            }
        });
        this.addTableListener();
    }

    private JPanel layoutContents() {
        JScrollPane tableScrollPane = new JScrollPane(this.alignmentTable);
        JPanel saveButtonPanel = new JPanel();
        saveButtonPanel.add((Component)this.saveButton, "Center");
        JPanel arrowPanel = new JPanel();
        arrowPanel.add((Component)this.backButton, "West");
        arrowPanel.add((Component)this.nextButton, "East");
        JPanel gotoPanel = new JPanel();
        gotoPanel.add((Component)this.goToButton, "West");
        gotoPanel.add((Component)this.goToField, "Center");
        gotoPanel.add((Component)this.numAlignmentsLabel, "East");
        JPanel navPanel = new JPanel();
        navPanel.setLayout(new GridLayout(0, 1));
        navPanel.add(gotoPanel);
        navPanel.add(arrowPanel);
        navPanel.add(new JSeparator());
        navPanel.add(this.saveButton);
        this.navigationWindow.setContentPane(navPanel);
        this.navigationWindow.pack();
        JPanel contents = new JPanel();
        contents.setLayout(new BorderLayout());
        contents.add((Component)tableScrollPane, "Center");
        return contents;
    }

    private void saveChanges() {
        try {
            AlignmentUtil.writeGoldStandardAlignmentPoints(this.alignments, this.alignmentFilename);
            System.out.println("Saved alignment changes to " + this.alignmentFilename);
        }
        catch (IOException e) {
            System.out.println("FAILED TO SAVE ALIGNMENTS: " + e);
        }
    }

    private void updateWindows() {
        ProbableAlignment alignment = this.getCurrentAlignment();
        if (alignment != null) {
            this.alignmentTable.setModel(new AnnotationDataModel(alignment));
            this.addTableListener();
        }
        this.backButton.setEnabled(this.currAlignment > 0);
        this.nextButton.setEnabled(this.currAlignment < this.alignments.size() - 1);
        this.goToField.setText(Integer.toString(this.currAlignment + 1));
        this.numAlignmentsLabel.setText(" of " + Integer.toString(this.alignments.size()));
    }

    private ProbableAlignment getCurrentAlignment() {
        if (this.alignments.size() == 0) {
            return null;
        }
        return (ProbableAlignment)this.alignments.get(this.currAlignment);
    }

    private void addTableListener() {
        this.alignmentTable.getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
            }
        });
    }

    public static Font increaseFontSize(Font font, double scale) {
        String fontName = font.getFontName();
        int style = font.getSize();
        int size = (int)((double)font.getSize() * scale);
        return new Font(fontName, style, size);
    }

    public static void main(String[] args) throws Exception {
        String sourceFile = args[0];
        String targetFile = args[1];
        String alignmentFile = args[2];
        ArrayList alignments = AlignmentUtil.loadGoldStandardAlignments(sourceFile, targetFile, alignmentFile);
        AnnotationTool annotationTool = new AnnotationTool(alignments, alignmentFile);
    }
}

