/*
 * Decompiled with CFR 0.152.
 */
package com.linearb.eval;

import com.linearb.util.sentence.Alignment;
import com.linearb.util.sentence.Grid;
import com.linearb.util.sentence.Phrase;
import java.util.Arrays;

public class ProbableAlignment
extends Alignment {
    protected boolean[][] sureAlignmentsArray;
    protected boolean[][] probableAlignmentsArray;
    protected int ID;

    public ProbableAlignment(Phrase source, Phrase target, Grid sureAlignments, Grid probableAlignments) {
        super(source, target, probableAlignments);
        this.sureAlignmentsArray = sureAlignments.generateBooleanArray();
        this.probableAlignmentsArray = probableAlignments.generateBooleanArray();
        this.ID = -1;
    }

    public ProbableAlignment(Alignment alignment) {
        super(alignment.getSource(), alignment.getTarget(), alignment.getAlignmentPoints());
        this.sureAlignmentsArray = alignment.getAlignmentPoints().generateBooleanArray();
        this.probableAlignmentsArray = alignment.getAlignmentPoints().generateBooleanArray();
        this.ID = -1;
    }

    public Grid getSureAlignmentPoints() {
        return new Grid(this.sureAlignmentsArray);
    }

    public Grid getProbableAlignmentPoints() {
        return new Grid(this.probableAlignmentsArray);
    }

    public Grid getAlignmentPoints() {
        return this.getProbableAlignmentPoints();
    }

    public boolean containsProbableAt(int x, int y) {
        return this.probableAlignmentsArray[x][y];
    }

    public boolean containsSureAt(int x, int y) {
        return this.sureAlignmentsArray[x][y];
    }

    public void addProbablePoint(int x, int y) {
        this.sureAlignmentsArray[x][y] = false;
        this.probableAlignmentsArray[x][y] = true;
    }

    public void addSurePoint(int x, int y) {
        this.sureAlignmentsArray[x][y] = true;
        this.probableAlignmentsArray[x][y] = true;
    }

    public void removePoint(int x, int y) {
        this.sureAlignmentsArray[x][y] = false;
        this.probableAlignmentsArray[x][y] = false;
    }

    public int getID() {
        return this.ID;
    }

    public void setID(int ID) {
        this.ID = ID;
    }

    public void transpose() {
        Phrase oldSource = this.source;
        this.source = this.target;
        this.target = oldSource;
        Grid sure = this.getSureAlignmentPoints();
        sure.transpose();
        this.sureAlignmentsArray = sure.generateBooleanArray();
        Grid probable = this.getProbableAlignmentPoints();
        probable.transpose();
        this.probableAlignmentsArray = probable.generateBooleanArray();
    }

    public String toAsciiGraph() {
        StringBuffer buffer = new StringBuffer();
        int longestTargetWord = 0;
        for (int i = 0; i < this.getTargetLength(); ++i) {
            longestTargetWord = Math.max(longestTargetWord, this.target.get(i).toString().length());
        }
        char[] space = new char[longestTargetWord];
        Arrays.fill(space, ' ');
        for (int i = 0; i < this.getSourceLength(); ++i) {
            buffer.append(space);
            for (int j = 0; j <= i; ++j) {
                buffer.append("  |");
            }
            buffer.append(this.source.get(i));
            buffer.append('\n');
        }
        buffer.append(space);
        buffer.append("  ");
        space = new char[this.getSourceLength() * 3 + 1];
        Arrays.fill(space, '-');
        buffer.append(space);
        buffer.append('\n');
        for (int row = 0; row < this.getTargetLength(); ++row) {
            String targetWord = this.target.get(row).toString();
            space = new char[longestTargetWord - targetWord.length()];
            Arrays.fill(space, ' ');
            buffer.append(space);
            buffer.append(targetWord);
            buffer.append("  |");
            for (int column = 0; column < this.getSourceLength(); ++column) {
                if (this.probableAlignmentsArray[column][row]) {
                    if (this.sureAlignmentsArray[column][row]) {
                        buffer.append("SS");
                    } else {
                        buffer.append("PP");
                    }
                } else {
                    buffer.append("  ");
                }
                buffer.append("|");
            }
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public static void main(String[] args) throws Exception {
    }
}

