/*
 * Decompiled with CFR 0.152.
 */
package com.linearb.eval;

import com.linearb.eval.ProbableAlignment;
import com.linearb.util.sentence.Alignment;
import com.linearb.util.sentence.AlignmentUtil;
import com.linearb.util.sentence.Coordinate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class AER {
    protected ArrayList referenceAlignments;

    public AER(ArrayList referenceAlignments) {
        this.referenceAlignments = referenceAlignments;
    }

    public double calculateAER(ArrayList hypothesisAlignments) {
        int totalSureAlignments = 0;
        int totalAlignments = 0;
        int correctSureAlignments = 0;
        int correctProbableAlignments = 0;
        for (int i = 0; i < this.referenceAlignments.size(); ++i) {
            Collection surePoints = this.getSureAlignmentPoints(i);
            Collection probablePoints = this.getProbableAlignmentPoints(i);
            Collection hypothesisPoints = this.getAlignmentPoints(hypothesisAlignments, i);
            correctSureAlignments += this.sizeOfIntersection(surePoints, hypothesisPoints);
            correctProbableAlignments += this.sizeOfIntersection(probablePoints, hypothesisPoints);
            totalSureAlignments += surePoints.size();
            totalAlignments += hypothesisPoints.size();
        }
        double numerator = correctSureAlignments + correctProbableAlignments;
        double denominator = totalAlignments + totalSureAlignments;
        return 1.0 - numerator / denominator;
    }

    protected double calculateRecall(ArrayList hypothesisAlignments) {
        int totalSureAlignments = 0;
        int correctSureAlignments = 0;
        for (int i = 0; i < this.referenceAlignments.size(); ++i) {
            Collection referencePoints = this.getSureAlignmentPoints(i);
            correctSureAlignments += this.sizeOfIntersection(referencePoints, this.getAlignmentPoints(hypothesisAlignments, i));
            totalSureAlignments += referencePoints.size();
        }
        return (double)correctSureAlignments / (double)totalSureAlignments;
    }

    protected double calculatePrecision(ArrayList hypothesisAlignments) {
        int totalAlignments = 0;
        int correctProbableAlignments = 0;
        for (int i = 0; i < this.referenceAlignments.size(); ++i) {
            Collection hypothesisPoints = this.getAlignmentPoints(hypothesisAlignments, i);
            correctProbableAlignments += this.sizeOfIntersection(this.getProbableAlignmentPoints(i), hypothesisPoints);
            totalAlignments += hypothesisPoints.size();
        }
        return (double)correctProbableAlignments / (double)totalAlignments;
    }

    private int sizeOfIntersection(Collection coords1, Collection coords2) {
        int size = 0;
        Iterator it = coords1.iterator();
        while (it.hasNext()) {
            Coordinate coord = (Coordinate)it.next();
            if (!coords2.contains(coord)) continue;
            ++size;
        }
        return size;
    }

    private Collection getAlignmentPoints(ArrayList alignments, int i) {
        Alignment alignment = (Alignment)alignments.get(i);
        return alignment.getAlignmentPoints().generateCoordinates();
    }

    private Collection getProbableAlignmentPoints(int i) {
        ProbableAlignment alignment = (ProbableAlignment)this.referenceAlignments.get(i);
        return alignment.getProbableAlignmentPoints().generateCoordinates();
    }

    private Collection getSureAlignmentPoints(int i) {
        ProbableAlignment alignment = (ProbableAlignment)this.referenceAlignments.get(i);
        return alignment.getSureAlignmentPoints().generateCoordinates();
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 4) {
            System.out.println("The first three arguments are the reference file in the gold standard format, and the last is a regular alignments file to evaluate");
            System.out.println("Usage: ref.source ref.target ref.wa hyp.align");
            System.exit(0);
        }
        AER eval = new AER(AlignmentUtil.loadGoldStandardAlignments(args[0], args[1], args[2]));
        ArrayList hypothesisAlignments = AlignmentUtil.loadAlignments(args[3]);
        double aer = eval.calculateAER(hypothesisAlignments);
        System.out.println("The Alignment Error Rate is " + aer);
    }
}

