// WordList.H
// Maintains list of word spellings in a hash table
// Adam Berger 2/00

#ifndef _WORDLISTH_
#define _WORDLISTH_

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include <assert.h>

typedef struct hash_node {
  char *str;
  int idx;
  struct hash_node *next;
} HASH_NODE;


class WordList {
public:
  WordList(int nWords_);
  int Size() const { return nWords; }
  const char *operator[](int w) const { return words[w]; }
  int operator[](const char *spelling) const;
  int add(const char *p);

private:
  int computeHash(const char *s) const;
  
private:
  char **words;
  int  nWords; 
  HASH_NODE **hashTable;
  int hashTableSize;
};

#endif
