#include "WordList.H"

static const float EXPANSION = 1.5; 

int WordList::operator[](const char *p) const {
  int hashval = computeHash(p);
  for (HASH_NODE* hn=hashTable[hashval]; hn!=0; hn=hn->next)
    if (!strcmp(hn->str,p)) return hn->idx;
  return -1;	   // not found 
}

WordList::WordList(int nWords_) { 
  // create hash table and array
  hashTableSize = (int) (EXPANSION * nWords_);
  hashTable = new HASH_NODE * [hashTableSize];
  memset(hashTable, 0, hashTableSize*sizeof(HASH_NODE *));
  words = new char *[nWords_];
  nWords = 0;
}

int WordList::add(const char *p) { 
  // add word to hash table and array 
  words[nWords] = strdup(p);
  int hashval = computeHash(p);
  for (HASH_NODE* hn=hashTable[hashval]; hn!=0; hn=hn->next)
    if (!strcmp(hn->str,p)) 
      return hn->idx;              // already there
  
  // create new node and stick at head of linked list
  HASH_NODE *nhn = new HASH_NODE[1];
  nhn->str  = strdup(p);
  nhn->idx  = nWords;
  nhn->next = hashTable[hashval];
  hashTable[hashval] = nhn;    
  
  nWords++;
  return nhn->idx;                // new item
}

  
int WordList::computeHash(const char *s) const {
  int k=strlen(s);
  int hashval = 1;
  for (int i=0; i<k; i++)
    hashval = s[i] + 31*hashval;
  hashval = hashval % hashTableSize;
  if (hashval<0) hashval*=-1;
  assert(hashval>=0 && hashval<hashTableSize);
  return hashval;
}
