// ======================================================================
// User.H: Code and constants which the user may (or must)
// modify. Used by align.C.
// ======================================================================

#ifndef _USERH_
#define _USERH_

// longest permissible line (i.e. sentence) in characters
const int MAXLINE = 100000;

// maximum number of sentences between anchors
const int MAX_SEGMENT = 1000;    

// a rough estimate is fine.
const int AVERAGE_SENT_LEN = 20;  

// We smooth the sentence-wide statistical TM with a 'lexical 
// delta-function' model: one iff the two sentences are lexically
// identical. The following is how much weight we give to this 
// delta model. This is particularly useful when there are
// language-independent markers ("anchors") in the two texts. 
const double LEXICAL_WEIGHT = 0.2;


// Any one-time initialization you might need to do should go here.
void u_open();

// return the probability that the french word is a translation of the
// english word. 
double u_getTranslationProb(const char *frenchWord, 
			  const char *englishWord);

// the translation model is a 2d matrix of word-to-word translation
// probs p(f|e), where e is some English word and f a French
// word. The next two methods should return the number of English 
// (French) terms in the p(f|e) model.
int u_getNEnglishTerms();
int u_getNFrenchTerms();

#endif
