#ifndef _ARRAYH_
#define _ARRAYH_

#include <unistd.h>
#include <assert.h>

template <class Type>
class Array {

public:
  Array(int size=0):realsize(size),maxsize(size) { 
    if (size) 
      array = new Type[size]; 
    else 
      array = (Type *) NULL; 
  }

  Array(const Array<Type> &a)
    : realsize(a.realsize), maxsize(a.maxsize), array((Type *) NULL) {
      array = new Type[a.realsize]; 
      *this = a; 
  }

  ~Array() { delete [] array; }
  
  Array<Type> &operator=(const Array<Type> &a) {
    if (maxsize < a.maxsize) Grow(a.maxsize,0);
    assert(a.array != NULL);
    for (int i=0; i<a.maxsize; i++) 
      array[i] = a.array[i];
    Grow(a.maxsize);    
    return *this;
  }

  Type &operator[](int idx) const { return array[idx]; }

  int Size() const { return maxsize; }

  void Grow(int newsize, int copy=1) { 
    if (realsize >= newsize) { 
      maxsize = newsize; 
      return; 
    }
    Type *newarray = new Type[newsize];
    assert(newarray != NULL);
    if (realsize) {
      if (copy)
	for (int i=0; i<maxsize; i++) 
	  newarray[i]=array[i];
      delete [] array;
    }
    array    = newarray;
    maxsize  = newsize;
    realsize = newsize;
  }
  
 
private:
  int realsize, maxsize;
  Type *array;	
};

#endif
