cd ..
lang=urdu
w=`pwd`

set -e

echo Aligning c-structures with f-structures...
java -ea -cp $w/dist/CorpusNavigator.jar:$w/lib/NumberTransLib.jar:$w/lib/fastutil-5.0.9.jar edu.cmu.cs.lti.avenue.navigation.tools.CFStructureAligner $w/config/$lang.properties

echo Generating Phi and Head Mappings...
java -ea -Xmx128M -cp $w/dist/CorpusNavigator.jar:$w/lib/NumberTransLib.jar edu.cmu.cs.lti.avenue.navigation.tools.PhiPlusMapper $w/config/$lang.properties

echo Aligning contexts...
java -ea -Xmx128M -cp $w/dist/CorpusNavigator.jar:$w/lib/NumberTransLib.jar edu.cmu.cs.lti.avenue.navigation.tools.ContextAligner $w/config/$lang.properties

echo Aligning fstructs...
java -ea -Xmx128M -cp $w/dist/CorpusNavigator.jar:$w/lib/NumberTransLib.jar:$w/lib/fastutil-5.0.9.jar edu.cmu.cs.lti.avenue.navigation.tools.ElicitedCorpusAligner $w/config/$lang.properties