package edu.cmu.cs.lti.avenue.morphology;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;

public interface Segmenter extends Serializable {

	// Segmenter(params...)
	public void induceMorphology(List<String> tokens) throws SegmenterException;

	public void setEvidenceCorpus(List<String> tokens) throws SegmenterException;

	/**
	 * Segments the word at all hypothesized morpheme boundaries
	 * 
	 * @param word
	 * @return
	 * @throws SegmenterException
	 */
	public String[] getCombinedSegmentation(String word) throws SegmenterException;
	
	public List<Paradigm> getParadigms(String word) throws SegmenterException;
	
	public List<Paradigm> getAllParadigms() throws SegmenterException;

	public void saveSegmentationModel(File path) throws SegmenterException, IOException;

	public void loadSegmentationModel(File path) throws SegmenterException, IOException;
}
