package cmonson.thirdPartyMorphologicalAnalyzers.arabic;

import java.io.*;
import java.net.ServerSocket;
import java.net.Socket;
import java.io.IOException;


public class AlmorgeanaServer extends Thread {
	
	private int port;
	
	private AlmorgeanaJavaWrapper almorgeana = null;

	public AlmorgeanaServer(File AlmorgeanaExecutable, File directoryContainingBuckwalterDataFiles, int port) {
		this.port = port;
		
		almorgeana = new AlmorgeanaJavaWrapper(AlmorgeanaExecutable, directoryContainingBuckwalterDataFiles);
		almorgeana.begin();
	}
	
	/**
	 * @param args the command line arguments which must look like:
	 *
	 * <stem-data-file> <suffix-data-file>
	 */
	public static void main(String[] args) {
		if (args.length != 3) {
			System.out.print("The command line must look like:");
			System.out.println("\tjava Arabic_Almorgeana <path-to-Almorgeana> <path-to-BuckwalterDataFiles> <port>");
			System.out.println("\n\tExiting...");
			System.exit(0);
		}
		
		AlmorgeanaServer arabic_Almorgeana = new AlmorgeanaServer(new File(args[0]), new File(args[1]), Integer.valueOf(args[2]));
		arabic_Almorgeana.start();
	}    
	
	public void run() {
		System.err.println();
		System.err.println("*** Starting up the Java Server wrapper around the Arabic Morphological analyzer/generator ALMORGEANA ***");
		System.err.println();

		try {
			// Create a socket to listen
			ServerSocket serverSocket = new ServerSocket(port);   
			
			System.err.println("**** The Java Server wrapper around the Arabic Morphological analyzer/generator ALMORGEANA is Waiting for clients to connect ****");
			
			// Wait for a connection
			for(;;) {                                    
				Socket client = serverSocket.accept();               
				HandleAClient clientThread = new HandleAClient(client, almorgeana);

				/**
				 * Only one client can be served at a time because there is only one instance of the PERL ALMORGEANA code running.
				 * If two clients were served at the same time then the wrong client might get the other client's output from ALMORGEANA.
				 * Hence this method is synchronized.
				 */
				synchronized(almorgeana) {
					clientThread.start();         
				}
			}
		}
		catch (IOException e){
			System.err.println();
			System.err.println("**** The Java Server wrapper around the Arabic Morphological analyzer/generator ALMORGEANA died. ****");
			System.err.println();
			System.err.println("     Here's the error message:");
			System.err.println();
			System.err.println(e.getMessage());
			System.err.println();
		}
		
		System.err.println();
		System.err.println(" **** Exiting the Java Server wrapper around the Arabic Morphological analyzer/generator ALMORGEANA ***");
		System.err.println();
	}
	
		
		
	static class HandleAClient extends Thread {
		
		private Socket client;
		private AlmorgeanaJavaWrapper almorgeana;
		
		private BufferedReader inFromClient;
		private PrintWriter outToClient;
		
		public HandleAClient(Socket client, AlmorgeanaJavaWrapper almorgeana) {
			this.client = client; 
			this.almorgeana = almorgeana;
		}

		public void run() {
			
			System.err.println();
			System.err.println(" **** the JAVA Arabic Morphology Server is starting a thread to serve a Client. ****");
			System.err.println();
			
			try {
			
				// Get streams to talk to the client
				
				inFromClient = new BufferedReader(new InputStreamReader(client.getInputStream(), "UTF-8"));
				outToClient = new PrintWriter(new OutputStreamWriter(client.getOutputStream()));
				
				interactWithClient();
				
				outToClient.close();
				inFromClient.close();
				client.close();
			}
			catch (IOException e) {
				System.err.println();
				System.err.println("**** JAVA Mapudungun Morphology Analyzer Client Died. ****");
				System.err.println();
				System.err.println("     Here's the error message:");
				System.err.println();
				System.err.println(e.getMessage());
				System.err.println();				
			}
			
			System.err.println();
			System.err.println(" **** the JAVA Mapudungun Morphology Client is exiting. ****");
			System.err.println();
			
		}

		private void interactWithClient() {
			int DEBUG = 1;       
			
			System.err.println();
			System.err.println("Waiting for Arabic Words to analyze OR Arabic analyses to generate from.");
			System.err.println("  Enter 1 word/analysis per line.");
			System.err.println("  To quit, enter the string \"**EXIT**\".");
			System.err.println();
			System.err.println();
			
			try {
				
				String outputStringForClient;
				
				String inputStringFromClient;
				while ((inputStringFromClient = inFromClient.readLine()) != null) {
				
					if (inputStringFromClient.contains("**EXIT**")) {
						return;
					}
					
					if (DEBUG > 0) {
						System.err.print("**The ALMORGEANA Java server is now processing the following input from a client: |");
						System.err.print(inputStringFromClient);
						System.err.println("|");
					}
					
					outputStringForClient = almorgeana.process(inputStringFromClient);
					
					if (DEBUG > 0) {
						System.err.println("**The result being returned from the ALMORGEANA Java server is: " + outputStringForClient);
					}
					
					outToClient.println(outputStringForClient);
					outToClient.flush();
					
				} // while 'in' is not null      
			} // try
			catch (Exception e) {
				e.printStackTrace();
			}
			

		}
	}
		
}

