package cmonson.thirdPartyMorphologicalAnalyzers.arabic;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;

public class AlmorgeanaJavaWrapper {


	private File almorgeanaExecutable;
	private File directoryContainingBuckwalterDataFiles;
	private Process almorgeana;
	private BufferedReader inFromAlmorgeana;
	private PrintWriter outToAlmorgeana;

	public AlmorgeanaJavaWrapper(File almorgeanaExecutable, File directoryContainingBuckwalterDataFiles) {
		this.almorgeanaExecutable = almorgeanaExecutable;
		this.directoryContainingBuckwalterDataFiles = directoryContainingBuckwalterDataFiles;
	}
		
	public boolean begin() {

		// Start up the PERL Almorgeana code as a Java Process
		ProcessBuilder almorgeanaBuilder = 
			new ProcessBuilder(
					almorgeanaExecutable.getAbsolutePath(), 
					"-bw",  
					"-dir:"+directoryContainingBuckwalterDataFiles.getAbsolutePath());
		almorgeanaBuilder.directory(almorgeanaExecutable.getParentFile());
		try {
			almorgeana = almorgeanaBuilder.start();
		} catch (IOException e) {
			System.err.println("Error Starting Almorgeana Java Wrapper:");
			e.printStackTrace();
			return false;
		}
		
		try {
			inFromAlmorgeana = new BufferedReader(new InputStreamReader(almorgeana.getInputStream(), "UTF-8"));
			outToAlmorgeana = new PrintWriter(new OutputStreamWriter(almorgeana.getOutputStream()));
			
		} catch (UnsupportedEncodingException e) {
			System.err.println("*** The Java Server wrapper around the Arabic Morphological analyzer/generator ALMORGEANA died.");
			System.err.println("    Here's the stack trace");
			e.printStackTrace();
			return false;
		}
		
		try {
			AlmorgeanaErrorReader almorgeanaErrorReader = new AlmorgeanaErrorReader(almorgeana);
			almorgeanaErrorReader.start();

		} catch (UnsupportedEncodingException e) {
			System.err.println("ERROR: Could not start an Error Reader for Almorgeana!!");
			e.printStackTrace();
			return false;
		}
		
		return true;
	} 

	public String process(String inputString) {
		outToAlmorgeana.println(inputString);
		outToAlmorgeana.flush();
		
		String outputString = null;
		try {
			outputString = inFromAlmorgeana.readLine();
		} catch (IOException e) {
			System.err.println("*** FAILED reading from Almorgeana.  Here's the StackTrace:");
			e.printStackTrace();
			
		}
		
		return outputString;
	}
	
	private static class AlmorgeanaErrorReader extends Thread {
		private Process almorgeana;
		private BufferedReader errFromAlmorgeana;

		
		private AlmorgeanaErrorReader(Process almorgeana) throws UnsupportedEncodingException {
			this.almorgeana = almorgeana;
			errFromAlmorgeana = new BufferedReader(new InputStreamReader(this.almorgeana.getErrorStream(), "UTF-8"));
		}
		
		@Override
		public  void run() {
			try {
				while (true) {
					String stringFromAlmorgeana = null;
					stringFromAlmorgeana = errFromAlmorgeana.readLine();
					if (stringFromAlmorgeana != null) {
						System.err.println("Almorgeana STDERR:  " + stringFromAlmorgeana);
					}
				}
			}
			catch (IOException e) {
				e.printStackTrace();
			}
		}
	}

}


