package cmonson.morphologyInduction.schemes;

import java.util.Collection;
import java.util.TreeSet;

import cmonson.morphologyInduction.morphemes.SetOfMorphemes;
import cmonson.morphologyInduction.morphemes.Affix;

public class SchemeSet<S extends AffixScheme> extends TreeSet<S> {

	private static final long serialVersionUID = 1L;

	public SchemeSet() {}
	
	public SchemeSet(Collection<? extends S> collection) {
		super(collection);
	}
	
	// Unfortunately this method must be here AND in SchemeList because
	// because there is no multiple inheritance in Java
	public SetOfMorphemes<Affix> getAllAffixes() {
		SetOfMorphemes<Affix> allAffixes = new SetOfMorphemes<Affix>();
		for (S scheme : this) {
			allAffixes.add(scheme.affixes);
		}
		
		return allAffixes;
	}
}
