package cmonson.morphologyInduction.networks;

import java.util.Set;

import cmonson.morphologyInduction.morphemes.SetOfMorphemes;
import cmonson.morphologyInduction.morphemes.Affix;
import cmonson.morphologyInduction.schemes.Level1Scheme;
import cmonson.morphologyInduction.schemes.Scheme;
import cmonson.morphologyInduction.searchAndProcessing.VerticalMetric;

/**
 * A marker interface to flag a (presumably) PartialOrderNetwork as searchable with a BottomUpSearch.
 * 
 * @author cmonson
 *
 */
public interface BottomUpSearchableNetwork {
	
	public Set<Level1Scheme> getSmallestSchemesAboveLevel0();

	public int getNumberOfParents(Scheme current);

	public Scheme getNthLargestParentByAdherents(Scheme current, int n);

	public Set<Scheme> getSmallers(Scheme current);

	public Scheme getASchemeByName(SetOfMorphemes<Affix> schemeName);

	public Scheme getNthBestParentBy(VerticalMetric verticalMetric, Scheme current, int n);

	public boolean isAffixPresentInNetwork(Affix suffix);
}
