package cmonson.morphologyInduction.javaExperiments;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

import cmonson.thirdPartyMorphologicalAnalyzers.arabic.AlmorgeanaServer;


public class ClientForAlmorgeana {

	/**
	 * @param args
	 * @throws IOException 
	 * @throws UnknownHostException 
	 * @throws InterruptedException 
	 */
	public static void main(String[] args) throws UnknownHostException, IOException, InterruptedException {
		
		//AlmorgeanaServer arabic_Almorgeana = new AlmorgeanaServer(new File("/afs/cs.cmu.edu/user/cmonson/Research/Data/Arabic/Aragen-PAK/Aragen.pm"), new File(args[1]), Integer.valueOf(args[2]));
		AlmorgeanaServer almorgeanaServer = new AlmorgeanaServer(new File(args[0]), new File(args[1]), Integer.valueOf(args[2]));

		/*
		 * Something is funny with path names.  Things work if I suck parameters right off the command line, but don't work if they are Java String literals.!! ARGH!!
		 */
		/*
		File almorgeanaExecutableFile = new File("/afs/cs.cmu.edu/user/cmonson/Research/Data/Arabic/Aragen-PAK/Aragen.pm");
		File directoryContainingBuckwalterDataFiles = 
			new File("/afs/cs.cmu.edu/user/cmonson/Research/Data/Arabic/arabic_resources/bama_ver2/data");
		AlmorgeanaServer almorgeanaServer = new AlmorgeanaServer(
				almorgeanaExecutableFile,
				directoryContainingBuckwalterDataFiles,
				4444);
				*/

//		AlmorgeanaServer almorgeanaServer = new AlmorgeanaServer(
//				new File("/afs/cs.cmu.edu/user/cmonson/Research/Data/Arabic/Aragen-PAK/Aragen.pm"),
//				new File("/afs/cs.cmu.edu/user/cmonson/Research/Data/Arabic/arabic_resources/bama_ver2/data"),
//				Integer.valueOf("4444"));

		almorgeanaServer.start();
		
		Socket socketToAlmorgeana = null;
		boolean succeeded = false;
		int counter = 0;
		while ( ! succeeded) {
			try {
				counter++;
				System.err.println("Try #" + counter + " to connect to Almorgeana Server");
				socketToAlmorgeana = new Socket(InetAddress.getByName(null), 4444);
				succeeded = true;
			}
			catch (java.net.ConnectException e) {
				Thread.sleep(5000);
			}
		}
		BufferedReader inFromAlmorgeana = new BufferedReader(new InputStreamReader(socketToAlmorgeana.getInputStream(), "UTF-8"));
		PrintWriter outToAlmorgeana = new PrintWriter(new OutputStreamWriter(socketToAlmorgeana.getOutputStream()));
 
		outToAlmorgeana.println("ktb");
		outToAlmorgeana.flush();
		String results = inFromAlmorgeana.readLine();
		
		System.err.println();
		System.err.println("RESULTS: " + results);
		System.err.println();
		
	}

}
