package cmonson;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;

public class RandomSchemeSelector {

	public static void main(String[] args) throws IOException {
		
		ArrayList<Integer> randomLineNumbers = new ArrayList<Integer>();
		ArrayList<Integer> linesToReadBetweenSchemes = new ArrayList<Integer>();
		
		Random randomNumberGenerator = new Random(System.currentTimeMillis());
		
		for (int i=0; i<100; i++) {
			//Integer randomLineNumber = randomNumberGenerator.nextInt(8339);
			Integer randomLineNumber = randomNumberGenerator.nextInt(6909);
			randomLineNumber -= 1;
			randomLineNumber *= 4;
			randomLineNumber += 53;
			
			randomLineNumbers.add(randomLineNumber);
		}
		
		Collections.sort(randomLineNumbers);
		
		for (int i=0; i<100; i++) {
			if (i==0) {
				linesToReadBetweenSchemes.add(randomLineNumbers.get(i)-1);
				
			} else {
				int prevLineNumber = randomLineNumbers.get(i-1);
				int currLineNumber = randomLineNumbers.get(i);
				int linesToRead = currLineNumber - prevLineNumber;
				linesToRead -= 4;
				linesToReadBetweenSchemes.add(linesToRead);
			}
		}
		
		BufferedReader schemesReader = 
			new BufferedReader(
				new InputStreamReader(
					//new FileInputStream("d:/Research/MorphologyInduction/Spanish/experiments-training50K/greedy-r.25-rmsta-schemes.txt")));
					new FileInputStream("H:/Research/MorphologyInduction/Spanish/experiments-training50K/ExperimentsForThesis/basicBus-50KTypesGT5Chars-schemes.txt")));
		
		PrintWriter out = 
			new PrintWriter(
				new BufferedWriter(
					//new FileWriter("H:/Research/MorphologyInduction/Spanish/experiments-training50K/ExperimentsForThesis/RandomSchemesFromBasicBus.txt")),
					new FileWriter("H:/Research/MorphologyInduction/Spanish/experiments-training50K/ExperimentsForThesis/RandomSchemesFromBasicBus-50KTypesGT5Chars.txt")),
				 true); 
		
		for (int i=0; i<100; i++) {
			int linesToRead = linesToReadBetweenSchemes.get(i);
			
			for (int lineDeltaCounter=0; lineDeltaCounter<linesToRead; lineDeltaCounter++) {
				schemesReader.readLine();
			}
			
			int schemeLineNumber = randomLineNumbers.get(i);
			int schemeNumber = schemeLineNumber - 53;
			schemeNumber /= 4;
			schemeNumber += 1;
			out.println("Scheme #: " + schemeNumber);
			out.println("Line #  : " + schemeLineNumber);
			for (int j=0; j<4; j++) {
				String line = schemesReader.readLine();
				out.println(line);
			}
		}
		
	}

}
