/*
 * Copyright (c) 2006, Jonathan Clark <jon_DOT_h_DOT_clark_AT_gmail_DOT_com> 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 *     * Redistributions of source code must retain the above copyright notice,
 *       this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright notice,
 *       this list of conditions and the following disclaimer in the documentation
 *       and/or other materials provided with the distribution.
 *     * Neither the name of my affiliates nor the names of thier contributors
 *       may be used to endorse or promote products derived from this software
 *       without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIEDWARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */
package info.jonclark.util;

import java.util.logging.Logger;

public class DebugUtils {

	private static boolean assertEnabled = false;
	private static boolean assertEvaluated = false;

	/**
	 * Determine if the assert keyword is enabled for this Virtual Machine. That
	 * is, "was the -ea option passed on startup?"
	 */
	public static boolean isAssertEnabled() {
		if (!assertEvaluated) {
			assertEvaluated = true;
			try {
				assert false;
			} catch (AssertionError e) {
				assertEnabled = true;
			}
		}
		return assertEnabled; 
	}

	/**
	 * Logs a message giving the current status of the assert keyword and
	 * provides user with information about what this means.
	 * 
	 * @param log
	 *            The logger to which the message will be added.
	 */
	public static void logAssertStatus(Logger log) {
		if (isAssertEnabled()) {
			log.info("The assert keyword is ENABLED.\n This is good for debugging, "
					+ "but could result in degraded program performance.");
		} else {
			log.info("The assert keyword is **DISABLED**.\n This is good for distribution,"
					+ "but could result in undetected errors. Asserts can be enabled by"
					+ "passing the -ea option to java.");
		}
	}
}
