/**
 * The AVENUE Project
 * Language Technologies Institute
 * School of Computer Science
 * (c) 2007 Carnegie Mellon University
 * 
 * Corpus Navigator
 * Written by Jonathan Clark
 */
package edu.cmu.cs.lti.avenue.trees.smart;

import info.jonclark.util.StringUtils;

import java.util.ArrayList;

public class Variable {

	private final ArrayList<TreeNode> values;

	/**
	 * @param value
	 *            A single treenode containing the variable values in BOTH its
	 *            children and values, a match on any of which is sufficient
	 */
	public Variable(TreeNode possibleValues) {
		this.values =
				new ArrayList<TreeNode>(possibleValues.getChildren().size()
						+ possibleValues.getValues().size());

		for (TreeNode child : possibleValues.getChildren()) {
			TreeNode loner = TreeNode.createOrphanNode(-1, SmartTree.SOURCE_C_STRUCT_LABEL);
			loner.addChild(child);
			values.add(loner);
		}

		for (String value : possibleValues.getValues()) {
			TreeNode lonerNested = TreeNode.createOrphanNode(-1, SmartTree.SOURCE_C_STRUCT_LABEL);
			lonerNested.addValue(value);
			TreeNode lonerOutside = TreeNode.createOrphanNode(-1, SmartTree.SOURCE_C_STRUCT_LABEL);
			lonerOutside.addChild(lonerNested);
			values.add(lonerOutside);
		}
	}

	public ArrayList<TreeNode> getValues() {
		return values;
	}

	public String toString() {
		return StringUtils.untokenize(values, " :: ");
	}
}
