/**
* The AVENUE Project
* Language Technologies Institute
* School of Computer Science
* (c) 2007 Carnegie Mellon University
* 
* Corpus Navigator
* Written by Jonathan Clark
*/
package edu.cmu.cs.lti.avenue.trees.smart;

import java.util.HashMap;
import java.util.Map.Entry;

public class SymbolTable {
	public final String[] variableNames;
	public final HashMap<String, Integer> variableIndices;
	public final Variable[] variablePossibleValues;

	/**
	 * @param variables
	 *            A single treenode containing the variable values in BOTH its
	 *            children and values, a match on any of which is sufficient
	 */
	public SymbolTable(HashMap<String, Variable> variables) {
		int i = 0;
		this.variableNames = new String[variables.size()];
		this.variableIndices = new HashMap<String, Integer>(variables.size());
		this.variablePossibleValues = new Variable[variables.size()];
		for (Entry<String, Variable> variable : variables.entrySet()) {
			this.variableNames[i] = variable.getKey();
			this.variableIndices.put(variable.getKey(), i);
			this.variablePossibleValues[i] = variable.getValue();
			i++;
		}
	}
}

