package edu.cmu.cs.lti.avenue.trees.cfg;

import info.jonclark.util.StringUtils;

import java.util.TreeMap;

public class SyncCfgRule {

	private CfgRule sourceRule;
	private CfgRule targetRule;
	private final TreeMap<String, Object> metadata = new TreeMap<String, Object>();

	private String[] str = new String[2];
	private int hashCode;

	public SyncCfgRule(String sourceLhs, String targetLhs, String[] sourceRhs, String[] targetRhs) {
		sourceRule = new CfgRule(sourceLhs, sourceRhs);
		targetRule = new CfgRule(targetLhs, targetRhs);
		cache();
	}

	public Object getMetaData(String key) {
		return metadata.get(key);
	}

	public void putMetaData(String key, Object value) {
		metadata.put(key, value);
		cache();
	}

	private void cache() {
		this.str[0] = makeString(false);
		this.str[1] = makeString(true);

		this.hashCode = toString(true).hashCode();
	}

	public int hashCode() {
		return hashCode;
	}

	public boolean equals(Object obj) {
		return this.toString().equals(obj.toString());
	}

	public String toString() {
		return toString(true);
	}

	public String toString(boolean includeMetaData) {
		return str[includeMetaData ? 1 : 0];
	}

	private String makeString(boolean includeMetaData) {
		String lhs = getSourceRule().getLhs() + "::" + getTargetRule().getLhs();
		String rhs =
				"[" + StringUtils.untokenize(getSourceRule().getRhs()) + "] -> ["
						+ StringUtils.untokenize(getTargetRule().getRhs()) + "]";

		StringBuilder meta = new StringBuilder("");
		if (includeMetaData) {
			meta.append(" ");
			for (final Object obj : metadata.values()) {
				meta.append("(" + obj.toString() + ")");
			}
		}

		return lhs + "  " + rhs + meta.toString();
	}

	public void setTargetRule(CfgRule targetRule) {
		this.targetRule = targetRule;
		cache();
	}

	public CfgRule getTargetRule() {
		return targetRule;
	}

	public void setSourceRule(CfgRule sourceRule) {
		this.sourceRule = sourceRule;
		cache();
	}

	public CfgRule getSourceRule() {
		return sourceRule;
	}
}
