package edu.cmu.cs.lti.avenue.trees.cfg;

import info.jonclark.util.StringUtils;

public class CfgRule {

	private String lhs;
	private String[] rhs;
	private String str;
	private int hashCode;

	public CfgRule(String lhs, String[] rhs) {
		this.lhs = lhs.trim();
		this.rhs = rhs;
		cache();
	}

	private void cache() {
		this.str = "[" + getLhs() + " -> " + StringUtils.untokenize(getRhs()) + "]";
		this.hashCode = str.hashCode();
	}

	public int hashCode() {
		return hashCode;
	}

	public boolean equals(Object obj) {
		return this.toString().equals(obj.toString());
	}

	public String toString() {
		return str;
	}

	public void setLhs(String lhs) {
		this.lhs = lhs;
		cache();
	}

	public String getLhs() {
		return lhs;
	}

	public void setRhs(String[] rhs) {
		this.rhs = rhs;
		cache();
	}

	public String[] getRhs() {
		return rhs;
	}
}
