package edu.cmu.cs.lti.avenue.trees.bitmapped;

import info.jonclark.util.StringPool;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

import edu.cmu.cs.lti.avenue.trees.smart.SmartTree;
import edu.cmu.cs.lti.avenue.trees.smart.TreeNode;
import edu.cmu.cs.lti.avenue.trees.smart.SmartTree.LabelDisplay;

public class StringBitmappedTree {

	private final int[] subtrees;
	private final TreeNode[] nodes;
	private static final StringPool pool = new StringPool();
	private final int pattern;

	public enum ChildSortOrder {
		ORDER_SENSITIVE, ORDER_INSENSITIVE
	};
	public enum ValueSortOrder {
		ORDER_SENSITIVE, ORDER_INSENSITIVE
	};
	public enum CaseSensitivity {
		CASE_SENSITIVE, CASE_INSENSITIVE
	};

	public StringBitmappedTree(SmartTree tree) {

		ArrayList<TreeNode> nodeList = tree.getLabeledNodes();
		nodes = nodeList.toArray(new TreeNode[nodeList.size()]);
		subtrees = new int[nodes.length];

		// get bit pattern for root
		String strRoot = normalize(tree.getRootNode());
		pattern = pool.map(strRoot);

		for (int i = 0; i < subtrees.length; i++) {
			String str = normalize(nodes[i]);
			subtrees[i] = pool.map(str);
		}

		// sort the arrays to be in parallel order
		Arrays.sort(subtrees);
		Arrays.sort(nodes, new Comparator<TreeNode>() {
			public int compare(TreeNode a, TreeNode b) {
				String strA = normalize(a);
				String strB = normalize(b);
				int nA = pool.map(strA);
				int nB = pool.map(strB);
				return nB - nA;
			}
		});
	}

	private static String normalize(TreeNode t) {
		return t.toString(LabelDisplay.NONE);
	}

	// TODO: Generalize to interface
	public boolean containsSubtree(StringBitmappedTree t) {
		int index = Arrays.binarySearch(subtrees, t.pattern);
		return (index != -1);
	}

	public boolean containsSubtree(TreeNode t) {
		String str = normalize(t);
		int n = pool.map(str);
		int index = Arrays.binarySearch(subtrees, n);
		return (index != -1);
	}
}
