package edu.cmu.cs.lti.avenue.trees.bitmapped;

public interface BitmappedTree {

	// we should eventually wind up with a single array representation of the
	// whole tree
	// PLUS a suffix-array-style representation of the subtrees
	// memory-intensive, but very fast
	
	// 1) every string value must be mapped to an integer value
	// 2) how do we distinguish between (A (B)) and (A B) [interned strings?]
	// 3) we should provide an option for order-sensitive vs not
	// 4) 

	/**
	 * Get bits, inclusive
	 * 
	 * @param i
	 * @param j
	 * @return
	 */
	public BitmappedTree getRange(int i, int j);

	public void setRange(int i, BitmappedTree b);

	public boolean getBitAt(int i);

	public void setBitAt(int i, boolean b);

	public BitmappedTree and(BitmappedTree b);

	public BitmappedTree or(BitmappedTree b);

	public boolean equals(BitmappedTree b);

	public boolean equals(Object obj);
}
