package edu.cmu.cs.lti.avenue.projection.ordering;

import info.jonclark.util.MathUtils;

import java.util.ArrayList;
import java.util.HashMap;

import edu.cmu.cs.lti.avenue.corpus.Alignment;
import edu.cmu.cs.lti.avenue.corpus.CorpusException;
import edu.cmu.cs.lti.avenue.trees.smart.TreeNode;

public class WeightedCenterOfMassOrderingModel extends OrderingModel {

	private final HashMap<String, Double> constituentWeights;
	private static final CenterOfMassOrderingModel average = new CenterOfMassOrderingModel();

	public WeightedCenterOfMassOrderingModel(HashMap<String, Double> constituentWeights) {
		this.constituentWeights = constituentWeights;
	}
	
	public double getPosition(TreeNode targetNode, Alignment alignment) throws CorpusException {
		
		// here, we use the target nodes indices with the source node labels
		ArrayList<Integer> targetIndices = targetNode.getTerminalIndices();

		// since we know that the targetIndex list must be sorted...
		assert targetIndices.size() == 0 || targetIndices.get(0) == MathUtils.min(targetIndices) : "Unsorted index list.";
		assert targetIndices.size() == 0
				|| targetIndices.get(targetIndices.size() - 1) == MathUtils.max(targetIndices) : "Unsorted index list.";

		if (targetIndices.size() > 0) {
				String constituentType = targetNode.getValues().get(0);
				Double weight = constituentWeights.get(constituentType);
				assert weight != null : "Unknown constituent type: " + constituentType;
				return average.getPosition(targetNode, alignment) * weight;
		} else {
			return -1;
		}
	}

}
