package edu.cmu.cs.lti.avenue.projection.ordering;

import java.util.ArrayList;

import edu.cmu.cs.lti.avenue.corpus.Alignment;
import edu.cmu.cs.lti.avenue.corpus.CorpusException;
import edu.cmu.cs.lti.avenue.trees.smart.TreeNode;

/**
 * Allows no ambiguity (overlap)
 * 
 * @author jon
 */
public class UnambiguousOrderingModel extends OrderingModel {

	private static final EndpointOrderingModel min = new EndpointOrderingModel(true);
	private static final EndpointOrderingModel max = new EndpointOrderingModel(false);

	public double getPosition(TreeNode targetNode, Alignment alignment)
			throws CorpusException {
		return min.getPosition(targetNode, alignment);
	}

	// public boolean hasAmbiguousOrdering(TreeNode sourceNodeA, TreeNode
	// sourceNodeB, Alignment alignment) {
	//
	// double minA = min.getPosition(sourceNodeA, alignment);
	// double maxA = max.getPosition(sourceNodeB, alignment);
	// double minB = min.getPosition(sourceNodeA, alignment);
	// double maxB = max.getPosition(sourceNodeB, alignment);
	//		
	// boolean aBeforeB = (minA < minB && maxA < minB);
	// boolean bBeforeA = (minB < minA && maxB < minA);
	//		
	// return (!aBeforeB && !bBeforeA);
	// }

	/**
	 * Gets the relative order of a list of TreeNodes as projected into a target
	 * language with the given word alignments.
	 * 
	 * @param sourceNodes
	 * @param alignment
	 * @return An array of the same length of nodes with each integer element in
	 *         the array referring to the index of the reordered element in the
	 *         original source side node list. *OR* NULL if no order could be
	 *         determined.
	 * @throws CorpusException
	 */
	public Ordering getOrder(ArrayList<TreeNode> targetNodes, Alignment alignment)
			throws CorpusException {

		Ordering minOrder = min.getOrder(targetNodes, alignment);
		Ordering maxOrder = max.getOrder(targetNodes, alignment);
		
		// 4) check to make sure position of each element is unambiguous
		// by making sure the orderings for min and max are the same
		// TODO: This could be written much more efficiently
		for (int i = 0; i < minOrder.relativePositions.length - 1; i++) {
			if (minOrder.relativePositions[i] != maxOrder.relativePositions[i]) {
				minOrder.ambiguous = true;
				break;
			}
		}

		return minOrder;
	}
}
