package edu.cmu.cs.lti.avenue.projection.ordering;

import info.jonclark.util.MathUtils;

import java.util.ArrayList;

import edu.cmu.cs.lti.avenue.corpus.Alignment;
import edu.cmu.cs.lti.avenue.corpus.CorpusException;
import edu.cmu.cs.lti.avenue.trees.smart.TreeNode;

public class MidpointOrderingModel extends OrderingModel {

	private static final EndpointOrderingModel min = new EndpointOrderingModel(true);
	private static final EndpointOrderingModel max = new EndpointOrderingModel(false);

	public double getPosition(TreeNode targetNode, Alignment alignment)
			throws CorpusException {
		ArrayList<Integer> targetIndices = targetNode.getTerminalIndices();

		// since we know that the targetIndex list must be sorted...
		assert targetIndices.size() == 0 || targetIndices.get(0) == MathUtils.min(targetIndices) : "Unsorted index list.";
		assert targetIndices.size() == 0
				|| targetIndices.get(targetIndices.size() - 1) == MathUtils.max(targetIndices) : "Unsorted index list.";

		if (targetIndices.size() > 0) {
			double posA =
					MathUtils.midpoint(min.getPosition(targetNode, alignment),
							max.getPosition(targetNode, alignment));
			return posA;
		} else {
			return -1;
		}
	}
}
