package edu.cmu.cs.lti.avenue.projection;

import java.util.ArrayList;

import edu.cmu.cs.lti.avenue.trees.smart.TreeNode;

public class ProjectionFeatures {
	public int ed = 0; // edit distance (for CFG rule)
	public int r = 0; // child reorderings
	public int di = 0; // discontinuities by interruption
	public int dus = 0; // discontinuities by unaligned source word
	public int dut = 0; // discontinuities by unaligned target word
	public int dd = 0; // discontinuities by dual alignment
	public int ag = 0; // ambiguities by grouping (# target words)
	public int lo = 0; // leftovers (sentence-level only)
	
	public ArrayList<TreeNode> unalignedTargets;
	
	private void toString(String s, int n, StringBuilder builder) {
		if(n != 0) {
			builder.append(s + "=" + n + "; "); 
		}
	}

	public String toString() {
		StringBuilder builder = new StringBuilder();
		toString("Reorderings", r, builder);
		toString("Interruptions", di, builder);
		toString("UnalignedSourceWords", dus, builder);
		toString("UnalignedTargetWords", dut, builder);
		toString("DualAlignments",dd, builder);
		toString("GroupAlignments", ag, builder);
		toString("Leftovers", lo, builder);
		toString("RhsEditDistance", r, builder);
		return builder.toString();
	}
}
