/**
* The AVENUE Project
* Language Technologies Institute
* School of Computer Science
* (c) 2007 Carnegie Mellon University
* 
* Corpus Navigator
* Written by Jonathan Clark
*/
package edu.cmu.cs.lti.avenue.navigation.wals;

import java.io.File;

public class SparsenessCalculator {
	public static void main(String[] args) throws Exception {

		if (args.length != 1) {
			System.err.println("Usage: program <wals_dir>");
			System.exit(1);
		}

		WALS wals = new WALS(new File(args[0]));

		String[] featureNames = wals.getFeatureNames();
		String[] languageNames = wals.getLanguageNames();
		int[][] array = wals.getWalsArray();

		for (int i = 0; i < languageNames.length; i++) {
			int nEntries = 0;
			for (int j = 0; j < featureNames.length; j++) {
				if (array[i][j] != 0)
					nEntries++;
			}
			System.out.println(languageNames[i] + ":" + nEntries);
		}
		System.out.println();
		System.out.println();

		for (int j = 0; j < featureNames.length; j++) {
			int nEntries = 0;
			for (int i = 0; i < languageNames.length; i++) {
				if (array[i][j] != 0)
					nEntries++;
			}
			System.out.println(featureNames[j] + ":" + nEntries);
		}
	}
}


