package edu.cmu.cs.lti.avenue.navigation.tools;

import java.util.ArrayList;

public class UtfUtils {

	public static ArrayList<String> getUtfTokens(String[] tokens) {
		ArrayList<String> list = new ArrayList<String>();
		for (final String tok : tokens) {
			if (containsUnicodeChars(tok)) {
				list.add(tok);
			}
		}
		return list;
	}

	public static int countUtfTokens(String[] tokens) {
		int n = 0;
		for (final String tok : tokens) {
			if (containsUnicodeChars(tok)) {
				n++;
			}
		}
		return n;
	}

	public static boolean containsRomanLetters(String str) {
		for (int i = 0; i < str.length(); i++) {
			char c = str.charAt(i);
			if (c >= 'a' && c <= 'z') {
				return true;
			} else if (c >= 'A' && c <= 'Z') {
				return true;
			}
		}
		return false;
	}

	public static boolean containsUnicodeChars(String str) {
		for (int i = 0; i < str.length(); i++) {
			char c = str.charAt(i);
			if (c >= Byte.MAX_VALUE) {
				return true;
			}
		}
		return false;
	}

	public static String removeUnicodeChars(String str) {
		StringBuilder builder = new StringBuilder();

		for (int i = 0; i < str.length(); i++) {
			char c = str.charAt(i);
			if (c < Byte.MAX_VALUE) {
				builder.append(c);
			}
		}

		return builder.toString().trim();
	}

	public static String replaceUnicodeCharsWith(String str, char replacement) {
		StringBuilder builder = new StringBuilder();

		for (int i = 0; i < str.length(); i++) {
			char c = str.charAt(i);
			if (c < Byte.MAX_VALUE) {
				builder.append(c);
			} else {
				builder.append(replacement);
			}
		}

		return builder.toString().trim();
	}

}
